class approveRejectPaymentRequestResponse {
  List<PaymentAccounts>? paymentAccounts;
  PaymentRequestDetails? paymentRequestDetails;
  List<PaymentModes>? paymentModes;
  String? error;
  String? message;

  approveRejectPaymentRequestResponse({
    this.paymentAccounts,
    this.paymentRequestDetails,
    this.paymentModes,
    this.error,
    this.message,
  });

  approveRejectPaymentRequestResponse.fromJson(Map<String, dynamic> json) {
    if (json['payment_accounts'] != null) {
      paymentAccounts = <PaymentAccounts>[];
      json['payment_accounts'].forEach((v) {
        paymentAccounts!.add(PaymentAccounts.fromJson(v));
      });
    }
    paymentRequestDetails =
        json['payment_request_details'] != null
            ? PaymentRequestDetails.fromJson(json['payment_request_details'])
            : null;
    if (json['payment_modes'] != null) {
      paymentModes = <PaymentModes>[];
      json['payment_modes'].forEach((v) {
        paymentModes!.add(PaymentModes.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (paymentAccounts != null) {
      data['payment_accounts'] =
          paymentAccounts!.map((v) => v.toJson()).toList();
    }
    if (paymentRequestDetails != null) {
      data['payment_request_details'] = paymentRequestDetails!.toJson();
    }
    if (paymentModes != null) {
      data['payment_modes'] = paymentModes!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class PaymentAccounts {
  String? id;
  String? name;
  String? accountBalance;

  PaymentAccounts({this.id, this.name, this.accountBalance});

  PaymentAccounts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    accountBalance = json['account_balance'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['account_balance'] = accountBalance;
    return data;
  }
}

class PaymentRequestDetails {
  String? id;
  String? accountId;
  String? requestingPurpose;
  String? description;
  String? amount;
  String? requestedAmount;
  String? paymentRequestModeId;
  String? bankName;
  String? bankBranchName;
  String? bankIfscCode;
  String? bankAccountHolderName;
  String? bankAccountNumber;
  String? bankUpiId;

  PaymentRequestDetails({
    this.id,
    this.accountId,
    this.requestingPurpose,
    this.description,
    this.amount,
    this.requestedAmount,
    this.paymentRequestModeId,
    this.bankName,
    this.bankBranchName,
    this.bankIfscCode,
    this.bankAccountHolderName,
    this.bankAccountNumber,
    this.bankUpiId,
  });

  PaymentRequestDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    accountId = json['account_id'];
    requestingPurpose = json['requesting_purpose'];
    description = json['description'];
    amount = json['amount'];
    requestedAmount = json['requested_amount'];
    paymentRequestModeId = json['payment_request_mode_id'];
    bankName = json['bank_name'];
    bankBranchName = json['bank_branch_name'];
    bankIfscCode = json['bank_ifsc_code'];
    bankAccountHolderName = json['bank_account_holder_name'];
    bankAccountNumber = json['bank_account_number'];
    bankUpiId = json['bank_upi_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['account_id'] = accountId;
    data['requesting_purpose'] = requestingPurpose;
    data['description'] = description;
    data['amount'] = amount;
    data['requested_amount'] = requestedAmount;
    data['payment_request_mode_id'] = paymentRequestModeId;
    data['bank_name'] = bankName;
    data['bank_branch_name'] = bankBranchName;
    data['bank_ifsc_code'] = bankIfscCode;
    data['bank_account_holder_name'] = bankAccountHolderName;
    data['bank_account_number'] = bankAccountNumber;
    data['bank_upi_id'] = bankUpiId;
    return data;
  }
}

class PaymentModes {
  String? id;
  String? name;

  PaymentModes({this.id, this.name});

  PaymentModes.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}
