import 'dart:io';

import 'package:flutter/material.dart';
import 'package:generp/Notifiers/HomeScreenNotifier.dart';
import 'package:generp/Utils/SharedpreferencesService.dart';
import 'package:generp/screens/LoginScreen.dart';
import 'package:generp/services/api_calling.dart';
import 'package:provider/provider.dart';

import '../Models/MissedCheckoutStripResponse.dart';
import '../Models/hrmModels/jobDescriptionResponse.dart';

class ProfileNotifer extends ChangeNotifier {
  var _profileImage = "";
  var _company = "";
  var _branch = "";
  var _designation;
  var _mobile_num = "";
  var _isLoading = false;
  var _secretKey = "";
  var _latestversion = "";
  var _releaseNotes = "";
  var _employeeName = "";
  var _employerID = "";
  var _employeeDesignation = "";
  var _employeeEmail = "";

  get profileImage => _profileImage;
  get company => _company;
  get branch => _branch;
  get designation => _designation;
  get mobileNUmber => _mobile_num;
  get isLoading => _isLoading;
  get secretKey => _secretKey;
  get latestVersion => _latestversion;
  get releaseNotes => _releaseNotes;
  get employeeName => _employeeName;
  get employeeeID => _employerID;
  get employeeDesignation => _employeeDesignation;
  get employeeEmail => _employeeEmail;

  Future<void> ProfileApiFunction(
    HomescreenNotifier prov,
    BuildContext context,
  ) async {
    try {
      final data = await ApiCalling.ProfileFunctionApi(
        prov.empId ?? "",
        prov.session ?? "",
      );

      if (data != null) {
        if (data.sessionExists == 1) {
          _profileImage = data.profilePic ?? "";
          _company = data.company ?? "";
          _branch = data.branchName ?? "";
          _designation = data.designation ?? "";
          _mobile_num = data.mobileNo ?? "";
          _isLoading = false;
          _secretKey = data.totpSecret!;
          _employeeName = data.empName ?? "";
          _employerID = data.empId ?? "";
          _employeeDesignation = data.designation ?? "";
          _employeeEmail = data.emailId ?? "";

          notifyListeners();
        } else if (data.sessionExists == 0) {
          SharedpreferencesService().clearPreferences();
          Navigator.push(
            context,
            MaterialPageRoute(builder: (context) => LoginScreen()),
          );
          notifyListeners();
          // print(data.toString());
        }
      } else {
        print("Something went wrong, Please try again.");
      }
    } on Exception catch (e) {
      print("$e");
    }
  }

  Future<void> VersionApiFunction() async {
    try {
      final data = await ApiCalling.checkAppVersionApi();
      if (data != null) {
        _latestversion = data.latestVersion ?? "";
        if (Platform.isAndroid) {
          _releaseNotes = data.releaseNotes ?? "";
        } else if (Platform.isIOS) {
          _releaseNotes = data.iosReleaseNotes ?? "";
        }
        notifyListeners();
      } else {
        print("Something went wrong, Please try again.");
      }
    } on Exception catch (e) {
      print("$e");
    }
  }

  MissedCheckoutStripResponse? _missedCheckoutData;

  MissedCheckoutStripResponse? get missedCheckoutData => _missedCheckoutData;

  /// Missed checkout Strip provider
  Future<void> fetchMissedCheckoutStrip(String empId, String session) async {
    try {
      final data = await ApiCalling.missedCheckoutStripApi(empId, session);
      debugPrint("No data received from API ");
      if (data != null) {
        _missedCheckoutData = data;
        notifyListeners(); // Notify UI to rebuild with new data
      } else {
        debugPrint("No data received from API");
      }
    } catch (e) {
      debugPrint("Error in fetchMissedCheckoutStrip: $e");
    }
  }


  String? _errorMessage;
  jobDescriptionResponse? _response;

  String? get errorMessage => _errorMessage;
  jobDescriptionResponse? get response => _response;

  Future<void> fetchJobDescription(
    HomescreenNotifier prov,
    BuildContext context,
  ) async {
    _isLoading = true;
    _errorMessage = null;
    _response = null;
    notifyListeners();

    try {
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);

      final result = await ApiCalling.jobDescriptAPI(
        provider.empId,
        provider.session,
      );

      if (result != null) {
        _response = result;
      } else {
        _errorMessage = "No job description data found!";
      }
    } catch (e) {
      _errorMessage = "Something went wrong: $e";
    }

    _isLoading = false;
    notifyListeners();
  }
}
