import 'package:flutter/material.dart';
import 'package:generp/Notifiers/HomeScreenNotifier.dart';
import 'package:generp/Utils/SharedpreferencesService.dart';
import 'package:generp/screens/LoginScreen.dart';
import 'package:generp/services/api_calling.dart';

import '../Utils/BackgroundLocationService.dart';

class LogoutNotifier extends ChangeNotifier {
  bool _logoutButtonClicked = false;
  bool _isLoading = false;
  bool get isLoading => _isLoading;

  bool get logoutButtonClicked => _logoutButtonClicked;

  set logoutButtonClicked(bool val) {
    _logoutButtonClicked = val;
    notifyListeners();
  }

  Future<void> LogoutApiFunction(
    HomescreenNotifier prov,
    BuildContext context,
  ) async {
    // print("lohi");
    try {
      final data = await ApiCalling.LogoutFunctionApi(
        prov.empId ?? "",
        prov.session ?? "",
      );
      if (data != null) {
        if (data.error == 0) {
          _isLoading = false;
          _logoutButtonClicked = false;
          await BackgroundLocationService.stopLocationService();
          SharedpreferencesService().clearPreferences();
          Navigator.push(
            context,
            MaterialPageRoute(builder: (context) => LoginScreen()),
          );
          notifyListeners();
        } else {
          // print(data.toString());
        }
      } else {}
      // {print("Something went wrong, Please try again.")}
    } on Exception catch (e) {
      print("$e");
    }
  }
}
