class loadGeneratorDetailsResponse {
  int? error;
  String? genId;
  String? genHashId;
  String? aname;
  String? emodel;
  String? spname;
  String? mob1;
  String? mob2;
  String? mail;
  String? cname;
  String? engineNo;
  String? dateOfEngineSale;
  String? altNo;
  String? btryNo;
  String? dgSetNo;
  String? state;
  String? district;
  String? address;
  String? loc;
  String? dispDate;
  String? cmsngDate;
  String? status;
  List<ComplaintCategoryList>? complaintCategoryList;
  List<ComplaintTypeList>? complaintTypeList;
  List<ComplaintDescriptionList>? complaintDescriptionList;
  String? nextService;
  List<ContactList>? contactList;
  List<ComplaintList>? complaintList;
  List<ScheduleList>? scheduleList;
  int? sessionExists;

  loadGeneratorDetailsResponse({
    this.error,
    this.genId,
    this.genHashId,
    this.aname,
    this.emodel,
    this.spname,
    this.mob1,
    this.mob2,
    this.mail,
    this.cname,
    this.engineNo,
    this.dateOfEngineSale,
    this.altNo,
    this.btryNo,
    this.dgSetNo,
    this.state,
    this.district,
    this.address,
    this.loc,
    this.dispDate,
    this.cmsngDate,
    this.status,
    this.complaintCategoryList,
    this.complaintTypeList,
    this.complaintDescriptionList,
    this.nextService,
    this.contactList,
    this.complaintList,
    this.scheduleList,
    this.sessionExists,
  });

  loadGeneratorDetailsResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    genId = json['gen_id'];
    genHashId = json['gen_hash_id'];
    aname = json['aname'];
    emodel = json['emodel'];
    spname = json['spname'];
    mob1 = json['mob1'];
    mob2 = json['mob2'];
    mail = json['mail'];
    cname = json['cname'];
    engineNo = json['engine_no'];
    dateOfEngineSale = json['date_of_engine_sale'];
    altNo = json['alt_no'];
    btryNo = json['btry_no'];
    dgSetNo = json['dg_set_no'];
    state = json['state'];
    district = json['district'];
    address = json['address'];
    loc = json['loc'];
    dispDate = json['disp_date'];
    cmsngDate = json['cmsng_date'];
    status = json['status'];
    if (json['complaint_category_list'] != null) {
      complaintCategoryList = <ComplaintCategoryList>[];
      json['complaint_category_list'].forEach((v) {
        complaintCategoryList!.add(ComplaintCategoryList.fromJson(v));
      });
    }
    if (json['complaint_type_list'] != null) {
      complaintTypeList = <ComplaintTypeList>[];
      json['complaint_type_list'].forEach((v) {
        complaintTypeList!.add(ComplaintTypeList.fromJson(v));
      });
    }
    if (json['complaint_description_list'] != null) {
      complaintDescriptionList = <ComplaintDescriptionList>[];
      json['complaint_description_list'].forEach((v) {
        complaintDescriptionList!.add(ComplaintDescriptionList.fromJson(v));
      });
    }
    nextService = json['next_service'];
    if (json['contact_list'] != null) {
      contactList = <ContactList>[];
      json['contact_list'].forEach((v) {
        contactList!.add(ContactList.fromJson(v));
      });
    }
    if (json['complaint_list'] != null) {
      complaintList = <ComplaintList>[];
      json['complaint_list'].forEach((v) {
        complaintList!.add(ComplaintList.fromJson(v));
      });
    }
    if (json['schedule_list'] != null) {
      scheduleList = <ScheduleList>[];
      json['schedule_list'].forEach((v) {
        scheduleList!.add(ScheduleList.fromJson(v));
      });
    }
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    data['gen_id'] = genId;
    data['gen_hash_id'] = genHashId;
    data['aname'] = aname;
    data['emodel'] = emodel;
    data['spname'] = spname;
    data['mob1'] = mob1;
    data['mob2'] = mob2;
    data['mail'] = mail;
    data['cname'] = cname;
    data['engine_no'] = engineNo;
    data['date_of_engine_sale'] = dateOfEngineSale;
    data['alt_no'] = altNo;
    data['btry_no'] = btryNo;
    data['dg_set_no'] = dgSetNo;
    data['state'] = state;
    data['district'] = district;
    data['address'] = address;
    data['loc'] = loc;
    data['disp_date'] = dispDate;
    data['cmsng_date'] = cmsngDate;
    data['status'] = status;
    if (complaintCategoryList != null) {
      data['complaint_category_list'] =
          complaintCategoryList!.map((v) => v.toJson()).toList();
    }
    if (complaintTypeList != null) {
      data['complaint_type_list'] =
          complaintTypeList!.map((v) => v.toJson()).toList();
    }
    if (complaintDescriptionList != null) {
      data['complaint_description_list'] =
          complaintDescriptionList!.map((v) => v.toJson()).toList();
    }
    data['next_service'] = nextService;
    if (contactList != null) {
      data['contact_list'] = contactList!.map((v) => v.toJson()).toList();
    }
    if (complaintList != null) {
      data['complaint_list'] = complaintList!.map((v) => v.toJson()).toList();
    }
    if (scheduleList != null) {
      data['schedule_list'] = scheduleList!.map((v) => v.toJson()).toList();
    }
    data['session_exists'] = sessionExists;
    return data;
  }
}

class ComplaintCategoryList {
  String? id;
  String? name;

  ComplaintCategoryList({this.id, this.name});

  ComplaintCategoryList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class ContactList {
  String? name;
  String? designation;
  String? mob1;
  String? mob2;
  String? mail;
  String? type;

  ContactList({
    this.name,
    this.designation,
    this.mob1,
    this.mob2,
    this.mail,
    this.type,
  });

  ContactList.fromJson(Map<String, dynamic> json) {
    name = json['name'];
    designation = json['designation'];
    mob1 = json['mob1'];
    mob2 = json['mob2'];
    mail = json['mail'];
    type = json['type'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['name'] = name;
    data['designation'] = designation;
    data['mob1'] = mob1;
    data['mob2'] = mob2;
    data['mail'] = mail;
    data['type'] = type;
    return data;
  }
}

class ComplaintList {
  String? complaintId;
  String? createdBy;
  String? complaintTypeName;
  String? technicianName;
  String? complaintCategoryName;
  String? openStatus;
  String? createdDate;

  ComplaintList({
    this.complaintId,
    this.createdBy,
    this.complaintTypeName,
    this.technicianName,
    this.complaintCategoryName,
    this.openStatus,
    this.createdDate,
  });

  ComplaintList.fromJson(Map<String, dynamic> json) {
    complaintId = json['complaint_id'];
    createdBy = json['created_by'];
    complaintTypeName = json['complaint_type_name'];
    technicianName = json['technician_name'];
    complaintCategoryName = json['complaint_category_name'];
    openStatus = json['open_status'];
    createdDate = json['created_date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['complaint_id'] = complaintId;
    data['created_by'] = createdBy;
    data['complaint_type_name'] = complaintTypeName;
    data['technician_name'] = technicianName;
    data['complaint_category_name'] = complaintCategoryName;
    data['open_status'] = openStatus;
    data['created_date'] = createdDate;
    return data;
  }
}

class ScheduleList {
  String? serviceScheduleId;
  String? name;
  String? complaintType;
  String? complaintCategory;
  String? complaintDescription;
  String? scheduleManagerName;
  String? complaintId;
  String? dueDate;
  String? status;
  String? feedbackStatus;
  String? createdDatetime;

  ScheduleList({
    this.serviceScheduleId,
    this.name,
    this.complaintType,
    this.complaintCategory,
    this.complaintDescription,
    this.scheduleManagerName,
    this.complaintId,
    this.dueDate,
    this.status,
    this.feedbackStatus,
    this.createdDatetime,
  });

  ScheduleList.fromJson(Map<String, dynamic> json) {
    serviceScheduleId = json['service_schedule_id'];
    name = json['name'];
    complaintType = json['complaint_type'];
    complaintCategory = json['complaint_category'];
    complaintDescription = json['complaint_description'];
    scheduleManagerName = json['schedule_manager_name'];
    complaintId = json['complaint_id'];
    dueDate = json['due_date'];
    status = json['status'];
    feedbackStatus = json['feedback_status'];
    createdDatetime = json['created_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['service_schedule_id'] = serviceScheduleId;
    data['name'] = name;
    data['complaint_type'] = complaintType;
    data['complaint_category'] = complaintCategory;
    data['complaint_description'] = complaintDescription;
    data['schedule_manager_name'] = scheduleManagerName;
    data['complaint_id'] = complaintId;
    data['due_date'] = dueDate;
    data['status'] = status;
    data['feedback_status'] = feedbackStatus;
    data['created_datetime'] = createdDatetime;
    return data;
  }
}

class ComplaintTypeList {
  String? id;
  String? name;

  ComplaintTypeList({this.id, this.name});

  ComplaintTypeList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class ComplaintDescriptionList {
  String? id;
  String? name;

  ComplaintDescriptionList({this.id, this.name});

  ComplaintDescriptionList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}
