class crmUniversalSearchResponse {
  List<Accounts>? accounts;
  List<Enquires>? enquires;
  List<Leads>? leads;
  String? error;
  String? message;

  crmUniversalSearchResponse({
    this.accounts,
    this.enquires,
    this.leads,
    this.error,
    this.message,
  });

  crmUniversalSearchResponse.fromJson(Map<String, dynamic> json) {
    if (json['accounts'] != null) {
      accounts = <Accounts>[];
      json['accounts'].forEach((v) {
        accounts!.add(Accounts.fromJson(v));
      });
    }
    if (json['enquires'] != null) {
      enquires = <Enquires>[];
      json['enquires'].forEach((v) {
        enquires!.add(Enquires.fromJson(v));
      });
    }
    if (json['leads'] != null) {
      leads = <Leads>[];
      json['leads'].forEach((v) {
        leads!.add(Leads.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (accounts != null) {
      data['accounts'] = accounts!.map((v) => v.toJson()).toList();
    }
    if (enquires != null) {
      data['enquires'] = enquires!.map((v) => v.toJson()).toList();
    }
    if (leads != null) {
      data['leads'] = leads!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class Accounts {
  String? aid;
  String? aname;
  String? accman;
  String? conper;
  String? conmob;
  String? aaddress;

  Accounts({
    this.aid,
    this.aname,
    this.accman,
    this.conper,
    this.conmob,
    this.aaddress,
  });

  Accounts.fromJson(Map<String, dynamic> json) {
    aid = json['aid'];
    aname = json['aname'];
    accman = json['accman'];
    conper = json['conper'];
    conmob = json['conmob'];
    aaddress = json['aaddress'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['aid'] = aid;
    data['aname'] = aname;
    data['accman'] = accman;
    data['conper'] = conper;
    data['conmob'] = conmob;
    data['aaddress'] = aaddress;
    return data;
  }
}

class Enquires {
  String? id;
  String? refType;
  String? refId;
  String? sourceId;
  String? referenceId;
  String? companyId;
  String? name;
  String? companyName;
  String? mobile;
  String? altMobile;
  String? emailId;
  String? country;
  String? state;
  String? district;
  String? subLocation;
  String? address;
  String? product;
  String? requirement;
  String? extraInfo;
  String? feedbackStatus;
  String? enquiryManagerEmpId;
  String? openStatus;
  String? closingReasonId;
  String? closingLeadId;
  String? closingEmpId;
  String? closingDatetime;
  String? enteredEmpId;
  String? isExist;
  String? createdDatetime;
  String? updatedDatetime;
  String? refName;

  Enquires({
    this.id,
    this.refType,
    this.refId,
    this.sourceId,
    this.referenceId,
    this.companyId,
    this.name,
    this.companyName,
    this.mobile,
    this.altMobile,
    this.emailId,
    this.country,
    this.state,
    this.district,
    this.subLocation,
    this.address,
    this.product,
    this.requirement,
    this.extraInfo,
    this.feedbackStatus,
    this.enquiryManagerEmpId,
    this.openStatus,
    this.closingReasonId,
    this.closingLeadId,
    this.closingEmpId,
    this.closingDatetime,
    this.enteredEmpId,
    this.isExist,
    this.createdDatetime,
    this.updatedDatetime,
    this.refName,
  });

  Enquires.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    refType = json['ref_type'];
    refId = json['ref_id'];
    sourceId = json['source_id'];
    referenceId = json['reference_id'];
    companyId = json['company_id'];
    name = json['name'];
    companyName = json['company_name'];
    mobile = json['mobile'];
    altMobile = json['alt_mobile'];
    emailId = json['email_id'];
    country = json['country'];
    state = json['state'];
    district = json['district'];
    subLocation = json['sub_location'];
    address = json['address'];
    product = json['product'];
    requirement = json['requirement'];
    extraInfo = json['extra_info'];
    feedbackStatus = json['feedback_status'];
    enquiryManagerEmpId = json['enquiry_manager_emp_id'];
    openStatus = json['open_status'];
    closingReasonId = json['closing_reason_id'];
    closingLeadId = json['closing_lead_id'];
    closingEmpId = json['closing_emp_id'];
    closingDatetime = json['closing_datetime'];
    enteredEmpId = json['entered_emp_id'];
    isExist = json['is_exist'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    refName = json['ref_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['ref_type'] = refType;
    data['ref_id'] = refId;
    data['source_id'] = sourceId;
    data['reference_id'] = referenceId;
    data['company_id'] = companyId;
    data['name'] = name;
    data['company_name'] = companyName;
    data['mobile'] = mobile;
    data['alt_mobile'] = altMobile;
    data['email_id'] = emailId;
    data['country'] = country;
    data['state'] = state;
    data['district'] = district;
    data['sub_location'] = subLocation;
    data['address'] = address;
    data['product'] = product;
    data['requirement'] = requirement;
    data['extra_info'] = extraInfo;
    data['feedback_status'] = feedbackStatus;
    data['enquiry_manager_emp_id'] = enquiryManagerEmpId;
    data['open_status'] = openStatus;
    data['closing_reason_id'] = closingReasonId;
    data['closing_lead_id'] = closingLeadId;
    data['closing_emp_id'] = closingEmpId;
    data['closing_datetime'] = closingDatetime;
    data['entered_emp_id'] = enteredEmpId;
    data['is_exist'] = isExist;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['ref_name'] = refName;
    return data;
  }
}

class Leads {
  String? lid;
  String? aname;
  String? accman;
  String? conper;
  String? conmob;
  String? aaddress;

  Leads({
    this.lid,
    this.aname,
    this.accman,
    this.conper,
    this.conmob,
    this.aaddress,
  });

  Leads.fromJson(Map<String, dynamic> json) {
    lid = json['lid'];
    aname = json['aname'];
    accman = json['accman'];
    conper = json['conper'];
    conmob = json['conmob'];
    aaddress = json['aaddress'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['lid'] = lid;
    data['aname'] = aname;
    data['accman'] = accman;
    data['conper'] = conper;
    data['conmob'] = conmob;
    data['aaddress'] = aaddress;
    return data;
  }
}
