class DistrictsResponse {
  List<Districts>? districts;
  String? error;
  String? message;

  DistrictsResponse({this.districts, this.error, this.message});

  DistrictsResponse.fromJson(Map<String, dynamic> json) {
    if (json['districts'] != null) {
      districts = <Districts>[];
      json['districts'].forEach((v) {
        districts!.add(Districts.fromJson(v));
      });
    }

    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};

    if (districts != null) {
      data['districts'] = districts!.map((v) => v.toJson()).toList();
    }

    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class Districts {
  String? id;
  String? state;
  String? district;
  String? date;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  Districts({
    this.id,
    this.state,
    this.district,
    this.date,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  Districts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    state = json['state'];
    district = json['district'];
    date = json['date'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['state'] = state;
    data['district'] = district;
    data['date'] = date;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}
