class ordersDetailsEditOrderViewResponse {
  OrderDetails? orderDetails;
  List<States>? states;
  String? error;
  String? message;

  ordersDetailsEditOrderViewResponse({
    this.orderDetails,
    this.states,
    this.error,
    this.message,
  });

  ordersDetailsEditOrderViewResponse.fromJson(Map<String, dynamic> json) {
    orderDetails =
        json['order_details'] != null
            ? OrderDetails.fromJson(json['order_details'])
            : null;
    if (json['states'] != null) {
      states = <States>[];
      json['states'].forEach((v) {
        states!.add(States.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (orderDetails != null) {
      data['order_details'] = orderDetails!.toJson();
    }
    if (states != null) {
      data['states'] = states!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class OrderDetails {
  String? id;
  String? orderNumber;
  String? orderNumberHash;
  String? accId;
  String? refType;
  String? refId;
  String? salesPersonEmpId;
  String? enteredEmpId;
  String? dispatchStateId;
  String? dispatchDistrictId;
  String? dispatchSubLocationId;
  String? dispatchPincode;
  String? dispatchAddress;
  String? basicAmount;
  String? cgstAmount;
  String? sgstAmount;
  String? igstAmount;
  String? paidAmount;
  String? totalAmount;
  String? status;
  String? orderReceivedDate;
  String? scheduledDispatchDate;
  String? otp;
  String? note;
  String? poViewFileName;
  String? poDirFilePath;
  String? unloadingScope;
  String? freightScope;
  String? erectionScope;
  String? saleOrderNumber;
  String? invoiceNumber;
  String? vehicleNumber;
  String? driverName;
  String? driverMobileNumber;
  String? tpcApplicable;
  String? requestedTpcAmount;
  String? level1TpcApprovedAmount;
  String? level2TpcApprovedAmount;
  String? tpcPaymentMode;
  String? tpcPaymentReferenceNo;
  String? tpcPaymentAttachmentDirFilePath;
  String? tpcPaymentAttachementViewFileName;
  String? tpcStatus;
  String? tpcAgentId;
  String? isExist;
  String? createdDatetime;
  String? updatedDatetime;
  String? accountName;
  String? gstNumber;
  String? billingAddress;
  String? district;
  String? state;
  String? subLocality;
  String? billingPincode;
  String? stateName;
  String? balanceAmount;
  String? districtName;
  String? subLocationName;
  String? adjustedAmount;
  String? enteredEmpName;
  String? salesPersonEmpName;
  Null tpcaAgentName;

  OrderDetails({
    this.id,
    this.orderNumber,
    this.orderNumberHash,
    this.accId,
    this.refType,
    this.refId,
    this.salesPersonEmpId,
    this.enteredEmpId,
    this.dispatchStateId,
    this.dispatchDistrictId,
    this.dispatchSubLocationId,
    this.dispatchPincode,
    this.dispatchAddress,
    this.basicAmount,
    this.cgstAmount,
    this.sgstAmount,
    this.igstAmount,
    this.paidAmount,
    this.totalAmount,
    this.status,
    this.orderReceivedDate,
    this.scheduledDispatchDate,
    this.otp,
    this.note,
    this.poViewFileName,
    this.poDirFilePath,
    this.unloadingScope,
    this.freightScope,
    this.erectionScope,
    this.saleOrderNumber,
    this.invoiceNumber,
    this.vehicleNumber,
    this.driverName,
    this.driverMobileNumber,
    this.tpcApplicable,
    this.requestedTpcAmount,
    this.level1TpcApprovedAmount,
    this.level2TpcApprovedAmount,
    this.tpcPaymentMode,
    this.tpcPaymentReferenceNo,
    this.tpcPaymentAttachmentDirFilePath,
    this.tpcPaymentAttachementViewFileName,
    this.tpcStatus,
    this.tpcAgentId,
    this.isExist,
    this.createdDatetime,
    this.updatedDatetime,
    this.accountName,
    this.gstNumber,
    this.billingAddress,
    this.district,
    this.state,
    this.subLocality,
    this.billingPincode,
    this.stateName,
    this.balanceAmount,
    this.districtName,
    this.subLocationName,
    this.adjustedAmount,
    this.enteredEmpName,
    this.salesPersonEmpName,
    this.tpcaAgentName,
  });

  OrderDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    orderNumber = json['order_number'];
    orderNumberHash = json['order_number_hash'];
    accId = json['acc_id'];
    refType = json['ref_type'];
    refId = json['ref_id'];
    salesPersonEmpId = json['sales_person_emp_id'];
    enteredEmpId = json['entered_emp_id'];
    dispatchStateId = json['dispatch_state_id'];
    dispatchDistrictId = json['dispatch_district_id'];
    dispatchSubLocationId = json['dispatch_sub_location_id'];
    dispatchPincode = json['dispatch_pincode'];
    dispatchAddress = json['dispatch_address'];
    basicAmount = json['basic_amount'];
    cgstAmount = json['cgst_amount'];
    sgstAmount = json['sgst_amount'];
    igstAmount = json['igst_amount'];
    paidAmount = json['paid_amount'];
    totalAmount = json['total_amount'];
    status = json['status'];
    orderReceivedDate = json['order_received_date'];
    scheduledDispatchDate = json['scheduled_dispatch_date'];
    otp = json['otp'];
    note = json['note'];
    poViewFileName = json['po_view_file_name'];
    poDirFilePath = json['po_dir_file_path'];
    unloadingScope = json['unloading_scope'];
    freightScope = json['freight_scope'];
    erectionScope = json['erection_scope'];
    saleOrderNumber = json['sale_order_number'];
    invoiceNumber = json['invoice_number'];
    vehicleNumber = json['vehicle_number'];
    driverName = json['driver_name'];
    driverMobileNumber = json['driver_mobile_number'];
    tpcApplicable = json['tpc_applicable'];
    requestedTpcAmount = json['requested_tpc_amount'];
    level1TpcApprovedAmount = json['level1_tpc_approved_amount'];
    level2TpcApprovedAmount = json['level2_tpc_approved_amount'];
    tpcPaymentMode = json['tpc_payment_mode'];
    tpcPaymentReferenceNo = json['tpc_payment_reference_no'];
    tpcPaymentAttachmentDirFilePath =
        json['tpc_payment_attachment_dir_file_path'];
    tpcPaymentAttachementViewFileName =
        json['tpc_payment_attachement_view_file_name'];
    tpcStatus = json['tpc_status'];
    tpcAgentId = json['tpc_agent_id'];
    isExist = json['is_exist'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    accountName = json['account_name'];
    gstNumber = json['gst_number'];
    billingAddress = json['billing_address'];
    district = json['district'];
    state = json['state'];
    subLocality = json['sub_locality'];
    billingPincode = json['billing_pincode'];
    stateName = json['state_name'];
    balanceAmount = json['balance_amount'];
    districtName = json['district_name'];
    subLocationName = json['sub_location_name'];
    adjustedAmount = json['adjusted_amount'];
    enteredEmpName = json['entered_emp_name'];
    salesPersonEmpName = json['sales_person_emp_name'];
    tpcaAgentName = json['tpca_agent_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['order_number'] = orderNumber;
    data['order_number_hash'] = orderNumberHash;
    data['acc_id'] = accId;
    data['ref_type'] = refType;
    data['ref_id'] = refId;
    data['sales_person_emp_id'] = salesPersonEmpId;
    data['entered_emp_id'] = enteredEmpId;
    data['dispatch_state_id'] = dispatchStateId;
    data['dispatch_district_id'] = dispatchDistrictId;
    data['dispatch_sub_location_id'] = dispatchSubLocationId;
    data['dispatch_pincode'] = dispatchPincode;
    data['dispatch_address'] = dispatchAddress;
    data['basic_amount'] = basicAmount;
    data['cgst_amount'] = cgstAmount;
    data['sgst_amount'] = sgstAmount;
    data['igst_amount'] = igstAmount;
    data['paid_amount'] = paidAmount;
    data['total_amount'] = totalAmount;
    data['status'] = status;
    data['order_received_date'] = orderReceivedDate;
    data['scheduled_dispatch_date'] = scheduledDispatchDate;
    data['otp'] = otp;
    data['note'] = note;
    data['po_view_file_name'] = poViewFileName;
    data['po_dir_file_path'] = poDirFilePath;
    data['unloading_scope'] = unloadingScope;
    data['freight_scope'] = freightScope;
    data['erection_scope'] = erectionScope;
    data['sale_order_number'] = saleOrderNumber;
    data['invoice_number'] = invoiceNumber;
    data['vehicle_number'] = vehicleNumber;
    data['driver_name'] = driverName;
    data['driver_mobile_number'] = driverMobileNumber;
    data['tpc_applicable'] = tpcApplicable;
    data['requested_tpc_amount'] = requestedTpcAmount;
    data['level1_tpc_approved_amount'] = level1TpcApprovedAmount;
    data['level2_tpc_approved_amount'] = level2TpcApprovedAmount;
    data['tpc_payment_mode'] = tpcPaymentMode;
    data['tpc_payment_reference_no'] = tpcPaymentReferenceNo;
    data['tpc_payment_attachment_dir_file_path'] =
        tpcPaymentAttachmentDirFilePath;
    data['tpc_payment_attachement_view_file_name'] =
        tpcPaymentAttachementViewFileName;
    data['tpc_status'] = tpcStatus;
    data['tpc_agent_id'] = tpcAgentId;
    data['is_exist'] = isExist;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['account_name'] = accountName;
    data['gst_number'] = gstNumber;
    data['billing_address'] = billingAddress;
    data['district'] = district;
    data['state'] = state;
    data['sub_locality'] = subLocality;
    data['billing_pincode'] = billingPincode;
    data['state_name'] = stateName;
    data['balance_amount'] = balanceAmount;
    data['district_name'] = districtName;
    data['sub_location_name'] = subLocationName;
    data['adjusted_amount'] = adjustedAmount;
    data['entered_emp_name'] = enteredEmpName;
    data['sales_person_emp_name'] = salesPersonEmpName;
    data['tpca_agent_name'] = tpcaAgentName;
    return data;
  }
}

class States {
  String? id;
  String? name;

  States({this.id, this.name});

  States.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}
