import '../commonModels/commonAccountLedgerResponse.dart';

class AddOrderViewResponse {
  List<Employees>? employees;
  List<States>? states;
  List<SaleProducts>? saleProducts;
  List<String>? unloadingScope;
  List<String>? freightScope;
  List<String>? erectionScope;
  String? error;
  String? message;

  // 🔹 New fields
  AccountDetails? accountDetails;
  List<Product>? productList;
  String? feedback;
  String? followupType;
  String? inTime;
  String? loc;
  int? sessionExists;

  AddOrderViewResponse({
    this.employees,
    this.states,
    this.saleProducts,
    this.unloadingScope,
    this.freightScope,
    this.erectionScope,
    this.error,
    this.message,
  });


  AddOrderViewResponse.fromJson(Map<String, dynamic> json) {
    if (json['employees'] != null) {
      employees = <Employees>[];
      json['employees'].forEach((v) {
        employees!.add(Employees.fromJson(v));
      });
    }
    if (json['states'] != null) {
      states = <States>[];
      json['states'].forEach((v) {
        states!.add(States.fromJson(v));
      });
    }
    if (json['sale_products'] != null) {
      saleProducts = <SaleProducts>[];
      json['sale_products'].forEach((v) {
        saleProducts!.add(SaleProducts.fromJson(v));
      });
    }
    // 🔹 add this
    accountDetails = json['account_details'] != null
        ? AccountDetails.fromJson(json['account_details']) // from addOrderAccontDetailsResponse.dart
        : null;

    unloadingScope =
        (json['unloading_scope'] as List?)?.map((e) => e.toString()).toList();
    freightScope =
        (json['freight_scope'] as List?)?.map((e) => e.toString()).toList();
    erectionScope =
        (json['erection_scope'] as List?)?.map((e) => e.toString()).toList();

    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (employees != null) {
      data['employees'] = employees!.map((v) => v.toJson()).toList();
    }
    if (states != null) {
      data['states'] = states!.map((v) => v.toJson()).toList();
    }
    if (saleProducts != null) {
      data['sale_products'] = saleProducts!.map((v) => v.toJson()).toList();
    }
    data['unloading_scope'] = unloadingScope;
    data['freight_scope'] = freightScope;
    data['erection_scope'] = erectionScope;
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class Employees {
  String? id;
  String? name;

  Employees({this.id, this.name});

  Employees.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class States {
  String? id;
  String? name;

  States({this.id, this.name});

  States.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class SaleProducts {
  String? id;
  String? productCode;
  String? project;
  String? subGroup;
  String? vendor1;
  String? vendor2;
  String? vendorCode;
  String? prodName;
  String? brand;
  String? imageDirFilePath;
  String? imageViewFileName;
  String? prodDesc;
  String? hsnCode;
  String? units;
  String? unitsId;
  String? worksMsl;
  String? refType;
  String? refId;
  String? price;
  String? type;
  String? status; // ✅ Added field
  String? productionProcessId;
  String? createdBy;
  String? datetime;
  String? isExists;
  String? updatedDatetime;

  SaleProducts({
    this.id,
    this.productCode,
    this.project,
    this.subGroup,
    this.vendor1,
    this.vendor2,
    this.vendorCode,
    this.prodName,
    this.brand,
    this.imageDirFilePath,
    this.imageViewFileName,
    this.prodDesc,
    this.hsnCode,
    this.units,
    this.unitsId,
    this.worksMsl,
    this.refType,
    this.refId,
    this.price,
    this.type,
    this.status,
    this.productionProcessId,
    this.createdBy,
    this.datetime,
    this.isExists,
    this.updatedDatetime,
  });

  SaleProducts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    productCode = json['product_code'];
    project = json['project'];
    subGroup = json['sub_group'];
    vendor1 = json['vendor_1'];
    vendor2 = json['vendor_2'];
    vendorCode = json['vendor_code'];
    prodName = json['prod_name'];
    brand = json['brand'];
    imageDirFilePath = json['image_dir_file_path'];
    imageViewFileName = json['image_view_file_name'];
    prodDesc = json['prod_desc'];
    hsnCode = json['hsn_code'];
    units = json['units'];
    unitsId = json['units_id'];
    worksMsl = json['works_msl'];
    refType = json['ref_type'];
    refId = json['ref_id'];
    price = json['price'];
    type = json['type'];
    status = json['status']; // ✅ Added
    productionProcessId = json['production_process_id'];
    createdBy = json['created_by'];
    datetime = json['datetime'];
    isExists = json['is_exists'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['product_code'] = productCode;
    data['project'] = project;
    data['sub_group'] = subGroup;
    data['vendor_1'] = vendor1;
    data['vendor_2'] = vendor2;
    data['vendor_code'] = vendorCode;
    data['prod_name'] = prodName;
    data['brand'] = brand;
    data['image_dir_file_path'] = imageDirFilePath;
    data['image_view_file_name'] = imageViewFileName;
    data['prod_desc'] = prodDesc;
    data['hsn_code'] = hsnCode;
    data['units'] = units;
    data['units_id'] = unitsId;
    data['works_msl'] = worksMsl;
    data['ref_type'] = refType;
    data['ref_id'] = refId;
    data['price'] = price;
    data['type'] = type;
    data['status'] = status; // ✅ Added
    data['production_process_id'] = productionProcessId;
    data['created_by'] = createdBy;
    data['datetime'] = datetime;
    data['is_exists'] = isExists;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}


class Product {
  String? productId;
  String? name;
  String? price;

  Product({this.productId, this.name, this.price});

  Product.fromJson(Map<String, dynamic> json) {
    productId = json['product_id'];
    name = json['name'];
    price = json['price'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['product_id'] = productId;
    data['name'] = name;
    data['price'] = price;
    return data;
  }
}
