class GetSourceOnReferenceResponse {
  String? error;
  List<References>? references;
  String? message;

  GetSourceOnReferenceResponse({this.error, this.references, this.message});

  GetSourceOnReferenceResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['references'] != null) {
      references = <References>[];
      json['references'].forEach((v) {
        references!.add(References.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (references != null) {
      data['references'] = references!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    return data;
  }
}

class References {
  String? id;
  String? sourceId;
  String? name;
  String? date;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  References({
    this.id,
    this.sourceId,
    this.name,
    this.date,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  References.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    sourceId = json['source_id'];
    name = json['name'];
    date = json['date'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['source_id'] = sourceId;
    data['name'] = name;
    data['date'] = date;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}
