class commonAccountlistResponse {
  List<AccountList>? accountList;
  String? error;
  String? message;

  commonAccountlistResponse({this.accountList, this.error, this.message});

  commonAccountlistResponse.fromJson(Map<String, dynamic> json) {
    if (json['account_list'] != null) {
      accountList = <AccountList>[];
      json['account_list'].forEach((v) {
        accountList!.add(AccountList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (accountList != null) {
      data['account_list'] = accountList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class AccountList {
  String? id;
  String? isPaymentAccount;
  String? createdEmployeeId;
  String? type;
  String? refId;
  String? name;
  String? subLocality;
  String? district;
  String? state;
  String? address;
  String? datetime;
  String? empId;
  String? bankName;
  String? bankBranchName;
  String? bankIfscCode;
  String? bankAccountHolderName;
  String? bankAccountNumber;
  String? bankUpiId;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? mob1;
  String? email;
  String? contactName;

  AccountList({
    this.id,
    this.isPaymentAccount,
    this.createdEmployeeId,
    this.type,
    this.refId,
    this.name,
    this.subLocality,
    this.district,
    this.state,
    this.address,
    this.datetime,
    this.empId,
    this.bankName,
    this.bankBranchName,
    this.bankIfscCode,
    this.bankAccountHolderName,
    this.bankAccountNumber,
    this.bankUpiId,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.mob1,
    this.email,
    this.contactName,
  });

  AccountList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    isPaymentAccount = json['is_payment_account'];
    createdEmployeeId = json['created_employee_id'];
    type = json['type'];
    refId = json['ref_id'];
    name = json['name'];
    subLocality = json['sub_locality'];
    district = json['district'];
    state = json['state'];
    address = json['address'];
    datetime = json['datetime'];
    empId = json['emp_id'];
    bankName = json['bank_name'];
    bankBranchName = json['bank_branch_name'];
    bankIfscCode = json['bank_ifsc_code'];
    bankAccountHolderName = json['bank_account_holder_name'];
    bankAccountNumber = json['bank_account_number'];
    bankUpiId = json['bank_upi_id'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    mob1 = json['mob1'];
    email = json['email'];
    contactName = json['contact_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['is_payment_account'] = isPaymentAccount;
    data['created_employee_id'] = createdEmployeeId;
    data['type'] = type;
    data['ref_id'] = refId;
    data['name'] = name;
    data['sub_locality'] = subLocality;
    data['district'] = district;
    data['state'] = state;
    data['address'] = address;
    data['datetime'] = datetime;
    data['emp_id'] = empId;
    data['bank_name'] = bankName;
    data['bank_branch_name'] = bankBranchName;
    data['bank_ifsc_code'] = bankIfscCode;
    data['bank_account_holder_name'] = bankAccountHolderName;
    data['bank_account_number'] = bankAccountNumber;
    data['bank_upi_id'] = bankUpiId;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['mob1'] = mob1;
    data['email'] = email;
    data['contact_name'] = contactName;
    return data;
  }
}
