class commonAccountdetailsResponse {
  AccountDetails? accountDetails;
  BalanceDetails? balanceDetails;
  List<LedgerList>? ledgerList;
  String? error;
  String? message;

  commonAccountdetailsResponse({
    this.accountDetails,
    this.balanceDetails,
    this.ledgerList,
    this.error,
    this.message,
  });

  commonAccountdetailsResponse.fromJson(Map<String, dynamic> json) {
    accountDetails =
        json['account_details'] != null
            ? AccountDetails.fromJson(json['account_details'])
            : null;
    balanceDetails =
        json['balance_details'] != null
            ? BalanceDetails.fromJson(json['balance_details'])
            : null;
    if (json['ledger_list'] != null) {
      ledgerList = <LedgerList>[];
      json['ledger_list'].forEach((v) {
        ledgerList!.add(LedgerList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (accountDetails != null) {
      data['account_details'] = accountDetails!.toJson();
    }
    if (balanceDetails != null) {
      data['balance_details'] = balanceDetails!.toJson();
    }
    if (ledgerList != null) {
      data['ledger_list'] = ledgerList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class AccountDetails {
  String? id;
  String? type;
  String? refId;
  String? name;
  String? address;
  String? createdDatetime;
  String? bankName;
  String? bankBranchName;
  String? bankIfscCode;
  String? bankAccountHolderName;
  String? bankAccountNumber;
  String? bankUpiId;
  String? state;
  String? district;
  String? subLocality;

  AccountDetails({
    this.id,
    this.type,
    this.refId,
    this.name,
    this.address,
    this.createdDatetime,
    this.bankName,
    this.bankBranchName,
    this.bankIfscCode,
    this.bankAccountHolderName,
    this.bankAccountNumber,
    this.bankUpiId,
    this.state,
    this.district,
    this.subLocality,
  });

  AccountDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    type = json['type'];
    refId = json['ref_id'];
    name = json['name'];
    address = json['address'];
    createdDatetime = json['created_datetime'];
    bankName = json['bank_name'];
    bankBranchName = json['bank_branch_name'];
    bankIfscCode = json['bank_ifsc_code'];
    bankAccountHolderName = json['bank_account_holder_name'];
    bankAccountNumber = json['bank_account_number'];
    bankUpiId = json['bank_upi_id'];
    state = json['state'];
    district = json['district'];
    subLocality = json['sub_locality'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['id'] = id;
    data['type'] = type;
    data['ref_id'] = refId;
    data['name'] = name;
    data['address'] = address;
    data['created_datetime'] = createdDatetime;
    data['bank_name'] = bankName;
    data['bank_branch_name'] = bankBranchName;
    data['bank_ifsc_code'] = bankIfscCode;
    data['bank_account_holder_name'] = bankAccountHolderName;
    data['bank_account_number'] = bankAccountNumber;
    data['bank_upi_id'] = bankUpiId;
    data['state'] = state;
    data['district'] = district;
    data['sub_locality'] = subLocality;
    return data;
  }
}

class BalanceDetails {
  String? totalDebit;
  String? totalCredit;
  String? balance;

  BalanceDetails({this.totalDebit, this.totalCredit, this.balance});

  BalanceDetails.fromJson(Map<String, dynamic> json) {
    totalDebit = json['total_debit'];
    totalCredit = json['total_credit'];
    balance = json['balance'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = Map<String, dynamic>();
    data['total_debit'] = totalDebit;
    data['total_credit'] = totalCredit;
    data['balance'] = balance;
    return data;
  }
}

class LedgerList {
  String? id;
  String? accountId;
  String? refType;
  String? refId;
  String? type;
  String? description;
  String? creditAmount;
  String? debitAmount;
  String? date;
  String? createdDatetime;

  LedgerList({
    this.id,
    this.accountId,
    this.refType,
    this.refId,
    this.type,
    this.description,
    this.creditAmount,
    this.debitAmount,
    this.date,
    this.createdDatetime,
  });

  LedgerList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    accountId = json['account_id'];
    refType = json['ref_type'];
    refId = json['ref_id'];
    type = json['type'];
    description = json['description'];
    creditAmount = json['credit_amount'];
    debitAmount = json['debit_amount'];
    date = json['date'];
    createdDatetime = json['created_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['account_id'] = accountId;
    data['ref_type'] = refType;
    data['ref_id'] = refId;
    data['type'] = type;
    data['description'] = description;
    data['credit_amount'] = creditAmount;
    data['debit_amount'] = debitAmount;
    data['date'] = date;
    data['created_datetime'] = createdDatetime;
    return data;
  }
}
