class PaymentCollectionWalletResponse {
  TotalDet? totalDet;
  List<HistoryList>? historyList;
  int? error;
  int? sessionExists;

  PaymentCollectionWalletResponse({
    this.totalDet,
    this.historyList,
    this.error,
    this.sessionExists,
  });

  PaymentCollectionWalletResponse.fromJson(Map<String, dynamic> json) {
    totalDet =
        json['total_det'] != null ? TotalDet.fromJson(json['total_det']) : null;
    if (json['history_list'] != null) {
      historyList = <HistoryList>[];
      json['history_list'].forEach((v) {
        historyList!.add(HistoryList.fromJson(v));
      });
    }
    error = json['error'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (totalDet != null) {
      data['total_det'] = totalDet!.toJson();
    }
    if (historyList != null) {
      data['history_list'] = historyList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class TotalDet {
  String? creditAmount;
  String? debitAmount;
  String? balanceAmount;

  TotalDet({this.creditAmount, this.debitAmount, this.balanceAmount});

  TotalDet.fromJson(Map<String, dynamic> json) {
    creditAmount = json['credit_amount'];
    debitAmount = json['debit_amount'];
    balanceAmount = json['balance_amount'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['credit_amount'] = creditAmount;
    data['debit_amount'] = debitAmount;
    data['balance_amount'] = balanceAmount;
    return data;
  }
}

class HistoryList {
  String? id;
  String? transactionType;
  String? description;
  String? amount;
  String? datetime;

  HistoryList({
    this.id,
    this.transactionType,
    this.description,
    this.amount,
    this.datetime,
  });

  HistoryList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    transactionType = json['transaction_type'];
    description = json['description'];
    amount = json['amount'];
    datetime = json['datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['transaction_type'] = transactionType;
    data['description'] = description;
    data['amount'] = amount;
    data['datetime'] = datetime;
    return data;
  }
}
