import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_slidable/flutter_slidable.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/financeProvider/RequestionListProvider.dart';
import 'package:generp/Notifiers/financeProvider/approveRejectPaymentRequestResponse.dart';
import 'package:generp/Utils/GlobalConstants.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/screens/finance/FileViewer.dart';
import 'package:intl/intl.dart';
import 'package:provider/provider.dart';

import '../../Notifiers/financeProvider/RequesitionLidtDetailsProvider.dart';
import '../../Utils/commonServices.dart';
import '../../Utils/dropdownTheme.dart';
import '../commonDateRangeFilter.dart';
import 'PaymentRequestionListDetails.dart';

class Allpaymentrequesitionlistsbymodes extends StatefulWidget {
  final String mode;
  final String pageTitleName;

  const Allpaymentrequesitionlistsbymodes({
    super.key,
    required this.mode,
    required this.pageTitleName,
  });

  @override
  State<Allpaymentrequesitionlistsbymodes> createState() =>
      _AllpaymentrequesitionlistsbymodesState();
}

class _AllpaymentrequesitionlistsbymodesState
    extends State<Allpaymentrequesitionlistsbymodes> {
  List<FocusNode> focusNodes = List.generate(10, (index) => FocusNode());
  Dropdowntheme ddtheme = Dropdowntheme();
  TextEditingController approvedAmount = TextEditingController();
  TextEditingController remarks = TextEditingController();

  TextEditingController paymentReferenceNumber = TextEditingController();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  late Commondaterangefilter cf;
  bool isLevel1Finalized = false;

  bool isLevel2Finalized = false;

  // Final decision on whether to show buttons
  bool shouldShowButtons = false;
  final numberFormat = NumberFormat.decimalPattern();

  final ScrollController _scrollController = ScrollController();

  @override
  void initState() {
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      cf = Commondaterangefilter();
      var provider = Provider.of<Requestionlistprovider>(
        context,
        listen: false,
      );
      provider.paymentRequestionListsAPIFunction(context, widget.mode, "", "");

      _scrollController.addListener(() {
        if (_scrollController.position.pixels >=
            _scrollController.position.maxScrollExtent - 200 &&
            !provider.isLoadingMore &&
            provider.hasMoreData) {
          provider.paymentRequestionListsAPIFunction(
            context,
            widget.mode,
            "",
            "",
            append: true,
          );
        }
      });

      final providerclear = Provider.of<Requesitionlidtdetailsprovider>(
        context,
        listen: false,
      );
      providerclear.resetAll();
    });
  }

  @override
  void dispose() {
    _scrollController.dispose();
    _connectivity.disposeStream();
    super.dispose();
  }

  //'Requested',
  // 'Level 1 Approved',
  // 'Level 2 Approved',
  // 'Level 1 Rejected',
  // 'Level 2 Rejected',
  // 'Processed',
  // 'Payment Rejected'

  Color getDecorationColor(value) {
    var color = AppColors.approved_bg_color;
    switch (value) {
      case 'Requested':
        return AppColors.requested_bg_color;
      case 'Level 1 Approved':
        return AppColors.approved_bg_color;
      case 'Level 1 Rejected':
        return AppColors.rejected_bg_color;
      case 'Level 2 Approved':
        return AppColors.approved_bg_color;
      case 'Level 2 Rejected':
        return AppColors.rejected_bg_color;
      case 'Processed':
        return AppColors.processed_bg_color;
      case 'Payment Rejected':
        return AppColors.rejected_bg_color;
    }
    return color;
  }

  Color getTextColor(value) {
    var color = AppColors.approved_text_color;
    switch (value) {
      case 'Requested':
        return AppColors.requested_text_color;
      case 'Level 1 Approved':
        return AppColors.approved_text_color;
      case 'Level 1 Rejected':
        return AppColors.rejected_text_color;
      case 'Level 2 Approved':
        return AppColors.approved_text_color;
      case 'Level 2 Rejected':
        return AppColors.rejected_text_color;
      case 'Processed':
        return AppColors.processed_text_color;
      case 'Payment Rejected':
        return AppColors.rejected_text_color;
    }
    return color;
  }

  getText(value) {
    var text = "A";
    switch (value) {
      case 'Requested':
        return "R";
      case 'Level 1 Approved':
        return "L1A";
      case 'Level 1 Rejected':
        return "L1R";
      case 'Level 2 Approved':
        return "L2A";
      case 'Level 2 Rejected':
        return "L2R";
      case 'Processed':
        return "P";
      case 'Payment Rejected':
        return "R";
    }
    return text;
  }

  double getSize(value) {
    var text = "A";
    switch (value) {
      case 'Requested':
        return 16.0;
      case 'Level 1 Approved':
        return 13.0;
      case 'Level 1 Rejected':
        return 13.0;
      case 'Level 2 Approved':
        return 13.0;
      case 'Level 2 Rejected':
        return 13.0;
      case 'Processed':
        return 16.0;
      case 'Payment Rejected':
        return 16.0;
    }
    return 18.0;
  }

  // @override
  // void dispose() {
  //   // TODO: implement dispose
  //   super.dispose();
  //   _connectivity.disposeStream();
  // }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return connection == "Online"
        ? Platform.isAndroid
        ? WillPopScope(
      onWillPop: () {
        return onBackPressed(context);
      },
      child: SafeArea(
        top: false,
        bottom: true,
        child: _scaffold(context),
      ),
    )
        : _scaffold(context)
        : NoNetwork(context);
  }

  bool shouldShowSwipeButtons(status) {
    isLevel1Finalized = [
      "Level 1 Approved",
      "Level 1 Rejected",
      "Level 1 approved",
      "Level 1 rejected",
    ].contains(status);

    isLevel2Finalized = [
      "Level 2 Approved",
      "Level 2 Rejected",
      "Level 2 approved",
      "Level 2 rejected",
    ].contains(status);
    if (widget.mode == "apr_lvl1") {
      shouldShowButtons = !isLevel1Finalized;
    } else if (widget.mode == "apr_lvl2") {
      shouldShowButtons =
          !isLevel2Finalized &&
              [
                "Requested",
                "Level 1 Approved",
                "Level 1 approved",
              ].contains(status);
    } else if (widget.mode == "process") {
      shouldShowButtons = [
        "Level 2 Approved",
        "Level 2 approved",
      ].contains(status);
    } else if (widget.mode == "self_apr_lvl2") {
      shouldShowButtons = ["Requested"].contains(status);
    }

    return shouldShowButtons;
  }

  Widget _scaffold(BuildContext context) {
    // isLevel1Finalized = [
    //   "Level 1 Approved",
    //   "Level 1 Rejected",
    //   "Level 1 approved",
    //   "Level 1 rejected",
    // ].contains(req_det.status);
    //
    // isLevel2Finalized = [
    //   "Level 2 Approved",
    //   "Level 2 Rejected",
    //   "Level 2 approved",
    //   "Level 2 rejected",
    // ].contains(req_det.status);

    return Consumer2<Requestionlistprovider, Requesitionlidtdetailsprovider>(
      builder: (context, provider, detailsProvider, child) {
        final requestLists = provider.requisitionList;
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2New(
            context,
            widget.pageTitleName,
            provider.resetForm,
            Row(
              children: [
                // InkResponse(
                //   onTap: () {
                //     _showOptionsSheet(context);
                //   },
                //   child: SvgPicture.asset("assets/svg/ic_download.svg",),
                // ),
                InkResponse(
                  onTap: () async {
                    HapticFeedback.selectionClick();
                    var cf = Commondaterangefilter();
                    var result = await cf.showFilterBottomSheet(context);
                    if (result != null) {
                      var dateRange = result['dateRange'] as DateTimeRange?;
                      print("dateRange: $dateRange");

                      var formatted = result['formatted'] as List<String>;
                      print("formatted: $formatted");

                      if (formatted.isNotEmpty) {
                        var fromDate = formatted[0]; // From date
                        var toDate = formatted[1]; // To date
                        print("from_date: $fromDate");
                        print("to_date: $toDate");
                        provider.paymentRequestionListsAPIFunction(
                          context,
                          widget.mode,
                          fromDate,
                          toDate,
                        );
                        // You can now use fromDate and toDate as needed
                        // For example, store them or pass to another function
                      } else {
                        print("No valid date range selected");
                      }
                    } else {
                      print("Bottom sheet closed without selection");
                    }
                  },
                  child: SvgPicture.asset(
                    "assets/svg/filter_ic.svg",
                    height: 25,
                  ),
                ),
              ],
            ),
            0xFFFFFFFF,
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body:
          provider.isLoading && requestLists.isEmpty
              ? Center(
            child: CircularProgressIndicator.adaptive(
              valueColor: AlwaysStoppedAnimation<Color>(
                AppColors.app_blue,
              ),
            ),
          )
              : requestLists.isNotEmpty
              ? RefreshIndicator(
            onRefresh: () async {
              provider.resetPagination();
              await provider.paymentRequestionListsAPIFunction(
                context,
                widget.mode,
                "",
                "",
              );
            },
            child: Scrollbar(
              controller: _scrollController, //  attach here
              thumbVisibility: false,
              child: ListView.builder(
                controller: _scrollController,
                physics: const AlwaysScrollableScrollPhysics(),
                itemCount:
                requestLists.length +
                    (provider.hasMoreData ? 1 : 0),
                itemBuilder: (context, index) {
                  //  loader row for pagination
                  if (index == requestLists.length) {
                    return provider.isLoadingMore
                        ? const Padding(
                      padding: EdgeInsets.all(16),
                      child: Center(
                        child: CircularProgressIndicator(),
                      ),
                    )
                        : const SizedBox.shrink();
                  }

                  //  Your swipe logic untouched
                  final request = requestLists[index];
                  shouldShowSwipeButtons(request.status);

                  return InkResponse(
                    onTap: () async {
                      HapticFeedback.selectionClick();
                      var res = await Navigator.push(
                        context,
                        MaterialPageRoute(
                          builder:
                              (context) => Paymentrequestionlistdetails(
                            pageName: widget.pageTitleName,
                            mode: widget.mode,
                            paymentRequestId:
                            requestLists[index].id,
                          ),
                          settings: RouteSettings(
                            name: "Paymentrequestionlistdetails",
                          ),
                        )
                      ).then((_) {
                        provider.paymentRequestionListsAPIFunction(context, widget.mode, "", "");
                      });
                      if (routeSettingName ==
                          "Paymentrequestionlistdetails") {
                        print("croos refresh");
                        provider.paymentRequestionListsAPIFunction(
                          context,
                          widget.mode,
                          "",
                          "",
                        );
                      }
                    },
                    child: Container(
                      margin: EdgeInsets.symmetric(
                        horizontal: 10,
                        vertical: 5,
                      ),
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(16),
                      ),
                      child: ClipRRect(
                        borderRadius: BorderRadius.circular(20),
                        child: Slidable(
                          startActionPane:
                          shouldShowButtons
                              ? ActionPane(
                            motion: const ScrollMotion(),
                            dragDismissible: false,

                            // dismissible: DismissiblePane(onDismissed: () {}),
                            children: [
                              if (shouldShowButtons &&
                                  ![
                                    "admin",
                                    "self",
                                  ].contains(widget.mode)) ...[
                                SlidableAction(
                                  onPressed: (context) {
                                    _showLevelRejectionSheet(
                                      context,
                                      requestLists[index].id,
                                    );
                                  },
                                  backgroundColor: Color(
                                    0xFFFFE5E5,
                                  ),
                                  foregroundColor: Color(
                                    0xFFEF3739,
                                  ),
                                  icon: Icons.clear,
                                  label: 'Reject',
                                ),
                              ],

                              if (widget.mode == "process") ...[
                                SlidableAction(
                                  onPressed: (context) {
                                    detailsProvider
                                        .approveRejectPaymentRequestAPIFunction(
                                      context,
                                      requestLists[index]
                                          .id,
                                    );
                                    detailsProvider.preValues();
                                    _showAddPaymentSheet(
                                      context,
                                      requestLists[index].id,
                                    );
                                  },
                                  backgroundColor: Color(
                                    0xFFFFF8E5,
                                  ),
                                  foregroundColor: Color(
                                    0xFFFFB600,
                                  ),
                                  icon: Icons.add,
                                  label: 'Add Payment',
                                ),
                              ],
                            ],
                          )
                              : null,
                          endActionPane:
                          shouldShowButtons
                              ? ActionPane(
                            motion: const ScrollMotion(),
                            key: ValueKey(
                              requestLists[index].id,
                            ),
                            dragDismissible: false,

                            // dismissible: DismissiblePane(
                            //
                            //   onDismissed: () {},
                            // closeOnCancel: true,
                            // resizeDuration: Duration(milliseconds: 300),),
                            children: [
                              if ([
                                "apr_lvl1",
                                "apr_lvl2",
                                "self_apr_lvl2",
                              ].contains(widget.mode)) ...[
                                SlidableAction(
                                  onPressed: (context) {
                                    detailsProvider
                                        .paymentRequesitionDetails(
                                      context,
                                      requestLists[index]
                                          .id,
                                    );
                                    detailsProvider.preValues();
                                    detailsProvider
                                        .approveRejectPaymentRequestAPIFunction(
                                      context,
                                      requestLists[index]
                                          .id,
                                    );
                                    _showLevelApprovalSheet(
                                      context,
                                      requestLists[index].id.toString(),
                                    );

                                  },
                                  backgroundColor: Color(
                                    0xFFE9FFE8,
                                  ),
                                  foregroundColor: Color(
                                    0xFF4CB443,
                                  ),
                                  icon: Icons.check,
                                  label: 'Approve',
                                ),
                              ],
                            ],
                          )
                              : null,

                          child: Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 10,
                            ),
                            child: Column(
                              children: [
                                Row(
                                  children: [
                                    Expanded(
                                      flex: 1,
                                      child: Container(
                                        height: 50,
                                        width: 50,
                                        padding: EdgeInsets.all(8.0),
                                        decoration: BoxDecoration(
                                          color: getDecorationColor(
                                            requestLists[index].status,
                                          ),
                                          shape: BoxShape.circle,
                                        ),
                                        child: Center(
                                          child: Text(
                                            getText(
                                              requestLists[index]
                                                  .status,
                                            ),
                                            style: TextStyle(
                                              color: getTextColor(
                                                requestLists[index]
                                                    .status,
                                              ),
                                              fontSize: getSize(
                                                requestLists[index]
                                                    .status,
                                              ),
                                              fontFamily: "JakartaBold",
                                            ),
                                          ),
                                        ),
                                      ),
                                    ),
                                    SizedBox(width: 10),
                                    Expanded(
                                      flex: 4,
                                      child: SizedBox(
                                        child: Column(
                                          crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                          children: [
                                            Text(
                                              requestLists[index]
                                                  .accountName!,
                                              maxLines: 1,
                                              overflow:
                                              TextOverflow.ellipsis,
                                              style: TextStyle(
                                                fontFamily:
                                                "JakartaRegular",
                                                fontSize: 14,
                                                color:
                                                AppColors
                                                    .semi_black,
                                              ),
                                            ),
                                            Text(
                                              "${requestLists[index].date}",
                                              style: TextStyle(
                                                fontFamily:
                                                "JakartaRegular",
                                                fontSize: 14,
                                                color:
                                                AppColors.app_blue,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    Expanded(
                                      flex: 3,
                                      child: Text(
                                        maxLines: 1,
                                        "₹ ${requestLists[index].amount!}",
                                        textAlign: TextAlign.right,
                                        style: TextStyle(
                                          fontFamily: "JakartaMedium",
                                          fontSize: 14,
                                          color: AppColors.app_blue,
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ],
                            ),
                          ),
                        ),
                      ),
                    ),
                  );
                },
              ),
            ),
          )
              : Emptywidget(context),
        );
      },
    );
  }

  Future<void> _showLevelApprovalSheet(
      BuildContext context,
      String paymentID
      ) {

    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Requesitionlidtdetailsprovider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),

                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          if (widget.mode == "apr_lvl1") ...[
                            Align(
                              alignment: Alignment.topLeft,
                              child: Text(
                                "Level 1 Approval",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                          ] else if (widget.mode == "apr_lvl2") ...[
                            Align(
                              alignment: Alignment.topLeft,
                              child: Text(
                                "Level 2 Approval",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                          ],

                          textControllerWidget(
                            context,
                            provider.requestedAmount,
                            "Requested Amount",
                            "Enter Requested Amount",
                                (p0) {},
                            TextInputType.numberWithOptions(),
                            true,
                            null,
                            null,
                            null,
                            null,
                          ),
                          textControllerWidget(
                            context,
                            provider.approvedAmount,
                            "Approved Amount",
                            "Enter Approved Amount",
                                (p0) {
                              provider.onChangeApprov(p0);
                            },
                            TextInputType.numberWithOptions(),
                            false,
                            null,
                            focusNodes[0],
                            focusNodes[1],
                            TextInputAction.next,
                          ),
                          if (provider.ApprovedAmountError != null) ...[
                            errorWidget(context, provider.ApprovedAmountError),
                          ],
                          textControllerWidget(
                            context,
                            remarks,
                            "Remarks",
                            "Enter Remarks",
                                (p0) {},
                            TextInputType.text,
                            false,
                            null,
                            focusNodes[1],
                            null,
                            TextInputAction.done,
                          ),
                          errorWidget(context, provider.remarksError),
                          TextWidget(context, "Proposed Payment Account"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<PaymentAccounts>(
                                    isExpanded: true,
                                    hint: Text(
                                      'Select Payment Account',
                                      style: TextStyle(fontSize: 14),
                                      overflow: TextOverflow.ellipsis,
                                    ),
                                    items:
                                    provider.paymentsAccounts
                                        .map(
                                          (paymenents) => DropdownMenuItem<
                                          PaymentAccounts
                                      >(
                                        value: paymenents,
                                        child: Text(
                                          paymenents.name ?? '',
                                          style: const TextStyle(
                                            fontSize: 14,
                                          ),
                                          overflow:
                                          TextOverflow.ellipsis,
                                        ),
                                      ),
                                    )
                                        .toList(),
                                    value: provider.selectedPaymentAccounts,
                                    onChanged: (PaymentAccounts? value) {
                                      if (value != null) {
                                        if (provider
                                            .paymentsAccounts
                                            .isNotEmpty) {
                                          provider.selectedPaymentAccounts =
                                              value;
                                          print(
                                            "Selected Complaint Type: ${value.name}, ID: ${value.id}",
                                          );
                                          provider.selectedID = value.id!;
                                          provider.selectedValue = value.name!;
                                          print(
                                            "hfjkshfg" +
                                                provider.selectedID.toString(),
                                          );
                                        }
                                      }
                                    },
                                    dropdownSearchData: DropdownSearchData(
                                      searchInnerWidgetHeight: 50,
                                      searchController:
                                      provider
                                          .paymentAccountSearchController,
                                      searchInnerWidget: Padding(
                                        padding: const EdgeInsets.all(8),
                                        child: TextFormField(
                                          controller:
                                          provider
                                              .paymentAccountSearchController,
                                          decoration: InputDecoration(
                                            isDense: true,
                                            contentPadding:
                                            const EdgeInsets.symmetric(
                                              horizontal: 10,
                                              vertical: 8,
                                            ),
                                            hintText: 'Search account...',
                                            border: OutlineInputBorder(
                                              borderRadius:
                                              BorderRadius.circular(8),
                                            ),
                                          ),
                                        ),
                                      ),
                                      searchMatchFn: (item, searchValue) {
                                        return item.value?.name
                                            ?.toLowerCase()
                                            .contains(
                                          searchValue.toLowerCase(),
                                        ) ??
                                            false;
                                      },

                                      // Optional: clear search text when dropdown closes
                                    ),
                                    onMenuStateChange: (isOpen) {
                                      if (!isOpen) {
                                        provider.paymentAccountSearchController
                                            .clear();
                                      }
                                    },
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                    ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                    ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          errorWidget(
                            context,
                            provider.selectpaymentAccountError,
                          ),
                          InkWell(
                            onTap: provider.isLoading
                                ? null //  Disable tap while loading
                                : () async {
                              HapticFeedback.selectionClick();

                              // Immediately show loading
                              provider.isLoading = true;

                              // Small delay to ensure rebuild and show spinner before API starts
                              await Future.delayed(const Duration(milliseconds: 300));

                              //  Call API
                              if (remarks.text.isNotEmpty) {
                                await provider.paymentrequisitionApproveSubmitAPIFunction(
                                context,
                                widget.mode,
                                paymentID,
                                safeNormalizeAmount(provider.approvedAmount.text),
                                remarks.text,
                                provider.selectedID,
                              );
                                await Provider.of<Requesitionlidtdetailsprovider>(
                                  context,
                                  listen: false,
                                );
                              } else {
                                provider.remarksError = "Please Enter Remarks.";
                                provider.selectpaymentAccountError = "Please Select Payment Account.";
                              }

                              //  Stop loading only if context is still active
                              if (context.mounted) {
                                provider.isLoading = false;
                              }

                            },
                            child: AnimatedContainer(
                              duration: const Duration(milliseconds: 200),
                              alignment: Alignment.center,
                              height: 45,
                              margin: const EdgeInsets.symmetric(horizontal: 5, vertical: 5),
                              decoration: BoxDecoration(
                                color: provider.isLoading ? Colors.grey : AppColors.app_blue,
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child: provider.isLoading
                                    ? const SizedBox(
                                  height: 20,
                                  width: 20,
                                  child: CircularProgressIndicator(
                                    strokeWidth: 2,
                                    valueColor: AlwaysStoppedAnimation<Color>(Colors.white),
                                  ),
                                )
                                    : const Text(
                                  "Submit",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(color: Colors.white),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).then((value) async {
      final provider = Provider.of<Requesitionlidtdetailsprovider>(
        context,
        listen: false,
      );
      await provider.resetRequired();
      var providerpage = Provider.of<Requestionlistprovider>(
        context,
        listen: false,
      );
      providerpage.paymentRequestionListsAPIFunction(context, widget.mode, "", "");

      // This runs only when the bottom sheet is explicitly popped

      // Use the original context with mounted check
      if (context.mounted) {
        WidgetsBinding.instance.addPostFrameCallback((timeStamp) async {
          if (context.mounted) {
            var provider = Provider.of<Requestionlistprovider>(
              context,
              listen: false,
            );
            final detailsprov = Provider.of<Requesitionlidtdetailsprovider>(
              context,
              listen: false,
            );
            detailsprov.resetAll();

            provider.paymentRequestionListsAPIFunction(
              context,
              widget.mode,
              "",
              "",
            );
            provider.resetPagination();
            await provider.paymentRequestionListsAPIFunction(
              context,
              widget.mode,
              "",
              "",
            );
          }
        });
      }
    });
  }
  String safeNormalizeAmount(String? input) {
    if (input == null || input.trim().isEmpty) return "0";

    // Remove currency symbols, commas and spaces - keep digits and dots
    String cleaned = input.replaceAll(RegExp(r'[^0-9.]'), '');

    // Handle multiple decimal points: keep only first dot
    int firstDot = cleaned.indexOf('.');
    if (firstDot != -1) {
      String before = cleaned.substring(0, firstDot + 1);
      String after = cleaned.substring(firstDot + 1).replaceAll('.', '');
      cleaned = before + after;
    }

    return cleaned.isEmpty ? "0" : cleaned;
  }


  Future<void> _showLevelRejectionSheet(BuildContext context, paymentID) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Requesitionlidtdetailsprovider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          if (widget.mode == "apr_lvl1") ...[
                            Align(
                              alignment: Alignment.topLeft,
                              child: Text(
                                "Level 1 Rejection",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                          ] else if (widget.mode == "apr_lvl2") ...[
                            Align(
                              alignment: Alignment.topLeft,
                              child: Text(
                                "Level 2 Rejection",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                          ],

                          textControllerReadonlyWidget(
                            context,
                            provider.requestedAmount,
                            "Requested Amount",
                                (p0) {},
                          ),

                          textControllerWidget(
                            context,
                            remarks,
                            "Remarks",
                            "Enter Remarks",
                                (p0) {
                              provider.remarksError = null;
                              provider.notifyListeners();
                            },
                            TextInputType.text,
                            false,
                            null,
                            focusNodes[2],
                            null,
                            TextInputAction.done,
                          ),
                          errorWidget(context, provider.remarksError),
                          const SizedBox(height: 10),
                          InkWell(
                            onTap: () {
                              if (provider.isLoading) {
                                print("⏸️ Reject button is loading - ignoring tap");
                                return;
                              }

                              HapticFeedback.selectionClick();

                              // Close keyboard
                              FocusScope.of(context).unfocus();

                              provider.paymentrequisitionRejectSubmitAPIFunction(
                                context,
                                widget.mode,
                                paymentID,
                                remarks.text,
                              );
                            },
                            child: Container(
                              alignment: Alignment.center,
                              height: 45,
                              margin: EdgeInsets.only(
                                left: 5.0,
                                right: 5.0,
                                top: 5.0,
                                bottom: 5.0,
                              ),
                              decoration: BoxDecoration(
                                color: provider.isLoading ? Colors.grey : AppColors.app_blue,
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child: provider.isLoading
                                    ? Row(
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    SizedBox(
                                      height: 20,
                                      width: 20,
                                      child: CircularProgressIndicator(
                                        strokeWidth: 2,
                                        valueColor: AlwaysStoppedAnimation<Color>(Colors.white),
                                      ),
                                    ),
                                    SizedBox(width: 10),
                                    Text(
                                      "Processing...",
                                      textAlign: TextAlign.center,
                                      style: TextStyle(
                                        color: Colors.white,
                                        fontSize: 16,
                                      ),
                                    ),
                                  ],
                                )
                                    : Text(
                                  "Submit",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    color: Colors.white,
                                    fontSize: 16,
                                    fontWeight: FontWeight.bold,
                                  ),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      print("closing Sheet");
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        var provider = Provider.of<Requestionlistprovider>(
          context,
          listen: false,
        );
        final detailsprov = Provider.of<Requesitionlidtdetailsprovider>(
          context,
          listen: false,
        );
        detailsprov.resetRequired();

        provider.paymentRequestionListsAPIFunction(
          context,
          widget.mode,
          "",
          "",
        );
      });
    });
  }



  Future<void> _showAddPaymentSheet(BuildContext context, paymentID) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Requesitionlidtdetailsprovider>(
                builder: (context, provider, child) {
                  // Fallback UI if provider data is not ready
                  return Container(
                    // Constrain the height to avoid overflow
                    constraints: BoxConstraints(
                      maxHeight: MediaQuery.of(context).size.height * 0.8,
                    ),
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    child: Column(
                      children: [
                        // Scrollable content
                        Expanded(
                          child: SingleChildScrollView(
                            child: Padding(
                              padding: EdgeInsets.only(
                                bottom:
                                MediaQuery.of(context).viewInsets.bottom,
                              ),
                              child: Column(
                                mainAxisSize: MainAxisSize.min,
                                children: [
                                  Row(
                                    children: [
                                      Expanded(
                                        child: Column(
                                          crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                          mainAxisSize: MainAxisSize.min,
                                          children: [
                                            Align(
                                              alignment: Alignment.topLeft,
                                              child: Text(
                                                "Add Approval",
                                                style: TextStyle(
                                                  color: AppColors.app_blue,
                                                  fontSize: 16,
                                                ),
                                              ),
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.proposedPaymentAccount,
                                              "Enter Proposed Payment Account",
                                                  (p0) {},
                                            ),
                                            TextWidget(
                                              context,
                                              "Payment Account",
                                            ),
                                            DropdownButtonHideUnderline(
                                              child: Row(
                                                children: [
                                                  Expanded(
                                                    child: DropdownButton2<
                                                        PaymentAccounts
                                                    >(
                                                      isExpanded: true,
                                                      hint: Text(
                                                        'Select Account',
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                        ),
                                                        overflow:
                                                        TextOverflow
                                                            .ellipsis,
                                                      ),
                                                      items:
                                                      provider
                                                          .paymentsAccounts
                                                          .map(
                                                            (
                                                            paymenents,
                                                            ) => DropdownMenuItem<
                                                            PaymentAccounts
                                                        >(
                                                          value:
                                                          paymenents,
                                                          child: Text(
                                                            paymenents
                                                                .name ??
                                                                '',
                                                            style: TextStyle(
                                                              fontSize:
                                                              14,
                                                            ),
                                                            overflow:
                                                            TextOverflow
                                                                .ellipsis,
                                                          ),
                                                        ),
                                                      )
                                                          .toList(),
                                                      value:
                                                      provider
                                                          .selectedPaymentAccounts,
                                                      onChanged: (
                                                          PaymentAccounts? value,
                                                          ) {
                                                        if (value != null &&
                                                            provider
                                                                .paymentsAccounts
                                                                .isNotEmpty) {
                                                          setState(() {
                                                            provider.selectedPaymentAccounts =
                                                                value;
                                                            provider.selectedID =
                                                            value.id!;
                                                            provider.selectedValue =
                                                            value.name!;
                                                            print(
                                                              "Selected Account: ${value.name}, ID: ${value.id}",
                                                            );
                                                          });
                                                        }
                                                      },
                                                      dropdownSearchData: DropdownSearchData(
                                                        searchInnerWidgetHeight:
                                                        50,
                                                        searchController:
                                                        provider
                                                            .paymentAccountSearchController,
                                                        searchInnerWidget: Padding(
                                                          padding:
                                                          const EdgeInsets.all(
                                                            8,
                                                          ),
                                                          child: TextFormField(
                                                            controller:
                                                            provider
                                                                .paymentAccountSearchController,
                                                            decoration: InputDecoration(
                                                              isDense: true,
                                                              contentPadding:
                                                              EdgeInsets.symmetric(
                                                                horizontal:
                                                                10,
                                                                vertical: 8,
                                                              ),
                                                              hintText:
                                                              'Search account...',
                                                              border: OutlineInputBorder(
                                                                borderRadius:
                                                                BorderRadius.circular(
                                                                  8,
                                                                ),
                                                              ),
                                                            ),
                                                          ),
                                                        ),
                                                        searchMatchFn: (
                                                            item,
                                                            searchValue,
                                                            ) {
                                                          return item
                                                              .value
                                                              ?.name
                                                              ?.toLowerCase()
                                                              .contains(
                                                            searchValue
                                                                .toLowerCase(),
                                                          ) ??
                                                              false;
                                                        },
                                                      ),
                                                      onMenuStateChange: (
                                                          isOpen,
                                                          ) {
                                                        if (!isOpen) {
                                                          provider
                                                              .paymentAccountSearchController
                                                              .clear();
                                                        }
                                                      },
                                                      buttonStyleData:
                                                      ddtheme
                                                          .buttonStyleData,
                                                      iconStyleData:
                                                      ddtheme.iconStyleData,
                                                      menuItemStyleData:
                                                      ddtheme
                                                          .menuItemStyleData,
                                                      dropdownStyleData:
                                                      ddtheme
                                                          .dropdownStyleData,
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.approvedAmountReadonly,
                                              "Approved Amount",
                                                  (p0) {},
                                            ),
                                            textControllerWidget(
                                              context,
                                              provider.approvedAmount,
                                              "Payment Amount",
                                              "Enter Payment Amount",
                                                  (p0) {
                                                if (numberFormat.parse(
                                                  provider
                                                      .approvedAmountReadonly
                                                      .text,
                                                ) <
                                                    numberFormat.parse(
                                                      provider
                                                          .approvedAmount
                                                          .text,
                                                    )) {
                                                  provider.proposedAmountError =
                                                  "Amount should not be greater than Approved amount";
                                                } else {
                                                  provider.proposedAmountError =
                                                  "";
                                                }
                                              },
                                              TextInputType.numberWithOptions(),
                                              false,
                                              null,
                                            ),
                                            errorWidget(
                                              context,
                                              provider.proposedAmountError,
                                            ),
                                            textControllerWidget(
                                              context,
                                              paymentReferenceNumber,
                                              "Enter Payment Reference Number",
                                              "Payment Reference Number",
                                                  (p0) {},
                                              TextInputType.text,
                                              false,
                                              null,
                                              focusNodes[3],
                                              focusNodes[4],
                                              TextInputAction.next,
                                            ),
                                            textControllerWidget(
                                              context,
                                              remarks,
                                              "Remarks",
                                              "Enter Remarks",
                                                  (p0) {},
                                              TextInputType.text,
                                              false,
                                              null,
                                              focusNodes[4],
                                              null,
                                              TextInputAction.done,
                                            ),
                                            InkResponse(
                                              onTap: () {
                                                HapticFeedback.selectionClick();
                                                _showAttachmentSheet(context);
                                              },
                                              child: Container(
                                                margin: EdgeInsets.symmetric(
                                                  vertical: 10,
                                                ),
                                                height: 45,
                                                width:
                                                MediaQuery.of(
                                                  context,
                                                ).size.width,
                                                decoration: BoxDecoration(
                                                  color: Color(0xFFE6F6FF),
                                                  borderRadius:
                                                  BorderRadius.circular(12),
                                                  border: Border.all(
                                                    color: AppColors.app_blue,
                                                    width: 0.5,
                                                  ),
                                                ),
                                                child: Center(
                                                  child: Text(
                                                    "Add Attachment",
                                                    style: TextStyle(
                                                      fontFamily:
                                                      "JakartaMedium",
                                                      color: AppColors.app_blue,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ),
                                            if (provider.imagePicked == 1 &&
                                                provider.imagePath != null) ...[
                                              Padding(
                                                padding:
                                                const EdgeInsets.symmetric(
                                                  vertical: 4.0,
                                                ),
                                                child: Row(
                                                  mainAxisAlignment:
                                                  MainAxisAlignment
                                                      .spaceBetween,
                                                  children: [
                                                    Text(
                                                      "${provider.imagePath}",
                                                      style: TextStyle(
                                                        color:
                                                        AppColors
                                                            .semi_black,
                                                        fontSize: 11,
                                                        fontWeight:
                                                        FontWeight.w600,
                                                      ),
                                                    ),
                                                    InkResponse(
                                                      onTap: () {
                                                        HapticFeedback.selectionClick();
                                                        setState(() {
                                                          provider.imagePicked =
                                                          0;
                                                          provider.imagePath =
                                                          null;
                                                          provider.imageFilePath =
                                                          null;
                                                        });
                                                      },
                                                      child: SvgPicture.asset(
                                                        "assets/svg/ic_close.svg",
                                                        width: 15,
                                                        height: 15,
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                            ],
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.accountName,
                                              "Enter Account Name",
                                                  (p0) {},
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.branch,
                                              "Enter Branch Name",
                                                  (p0) {},
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.requestingPurpose,
                                              "Enter Requesting Purpose",
                                                  (p0) {},
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.description,
                                              "Enter Description",
                                                  (p0) {},
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.amount,
                                              "Enter Amount",
                                                  (p0) {},
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.paymentMode,
                                              "Enter Payment Mode",
                                                  (p0) {},
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.bankHolderName,
                                              "Bank Account Holder Name",
                                                  (p0) {},
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.bankAccountNumber,
                                              "Bank Account Number",
                                                  (p0) {},
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.bankName,
                                              "Bank Name",
                                                  (p0) {},
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.bankBranchName,
                                              "Bank Branch Name",
                                                  (p0) {},
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.bankIfscCode,
                                              "Bank IFSC Code",
                                                  (p0) {},
                                            ),
                                            textControllerReadonlyWidget(
                                              context,
                                              provider.bankUpiID,
                                              "Bank UPI ID",
                                                  (p0) {},
                                            ),
                                          ],
                                        ),
                                      ),
                                    ],
                                  ),
                                ],
                              ),
                            ),
                          ),
                        ),
                        // Sticky Submit Button
                        Padding(
                          padding: EdgeInsets.only(
                            left: 5.0,
                            right: 5.0,
                            top: 5.0,
                            bottom: 5.0,
                          ),
                          child: InkWell(
                            onTap: () {
                              HapticFeedback.selectionClick();
                              provider
                                  .paymentrequisitionProcessSubmitAPIFunction(
                                context,
                                widget.mode,
                                paymentReferenceNumber.text,
                                provider.approvedAmount.text,
                                paymentID,
                                provider.selectedID,
                                remarks.text,
                                provider.imagePath,
                              );
                            },
                            child: Container(
                              height: 45,
                              decoration: BoxDecoration(
                                color: AppColors.app_blue,
                                borderRadius: BorderRadius.circular(14.0),
                              ),
                              child: Center(
                                child: Text(
                                  "Submit",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(color: Colors.white),
                                ),
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    ).whenComplete(() {
      print("closing Sheet");
      WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
        var provider = Provider.of<Requestionlistprovider>(
          context,
          listen: false,
        );
        final detailsprov = Provider.of<Requesitionlidtdetailsprovider>(
          context,
          listen: false,
        );
        detailsprov.resetAll();

        provider.paymentRequestionListsAPIFunction(
          context,
          widget.mode,
          "",
          "",
        );
      });
    });
  }

  Future<void> _showAttachmentSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Requesitionlidtdetailsprovider>(
                builder: (context, provider, child) {
                  return Padding(
                    padding: EdgeInsets.only(
                      bottom:
                      MediaQuery.of(
                        context,
                      ).viewInsets.bottom, // This handles keyboard
                    ),
                    child: Container(
                      margin: EdgeInsets.only(
                        bottom: 15,
                        left: 15,
                        right: 15,
                        top: 10,
                      ),

                      child: SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Align(
                              alignment: Alignment.center,
                              child: Text(
                                "Select Source",
                                style: TextStyle(
                                  color: AppColors.app_blue,
                                  fontSize: 16,
                                ),
                              ),
                            ),
                            SizedBox(height: 15),
                            InkWell(
                              onTap: () {
                                HapticFeedback.selectionClick();
                                Navigator.of(context).pop(false);
                                provider.imgFromGallery(context);
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Select photo from gallery"),
                              ),
                            ),
                            SizedBox(height: 10),
                            InkWell(
                              onTap: () {
                                HapticFeedback.selectionClick();
                                Navigator.of(context).pop(false);
                                provider.imgFromCamera(context);
                              },
                              child: SizedBox(
                                height: 35,
                                child: Text("Capture photo from camera"),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
