import 'package:flutter/cupertino.dart';
import 'package:generp/Notifiers/HomeScreenNotifier.dart';
import 'package:generp/services/api_calling.dart';
import 'package:provider/provider.dart';

import '../Models/FollowUpResponse.dart';
import '../Models/ServiceComplaintBillListResponse.dart';
import '../Models/ViewVisitDetailsResponseNew.dart';
import '../Utils/commonServices.dart';

class Visitdetailsprovider extends ChangeNotifier {
  bool _showMoreDetails = false;

  CustomerDetails _customerDetails = CustomerDetails();
  GeneratorDetails _generatorDetails = GeneratorDetails();
  ComplaintDetailsNew _complaintDetailsNew = ComplaintDetailsNew();
  List<Followuplist> _followupList = [];
  List<ComplaintList> _complaintList = [];
  bool _isLoading = false;

  CustomerDetails get customerDetails => _customerDetails;
  GeneratorDetails get generatorDetails => _generatorDetails;
  ComplaintDetailsNew get complaintDetailsNew => _complaintDetailsNew;
  List<Followuplist> get followUpList => _followupList;
  List<ComplaintList> get complaintList => _complaintList;
  bool get isLoading => _isLoading;
  bool get showMoreDetails => _showMoreDetails;

  // ==== FIX FOR THE CRASH ====
  bool _disposed = false;
  @override
  void dispose() {
    _disposed = true;
    super.dispose();
  }

  void safeNotifyListeners() {
    if (!_disposed) notifyListeners();
  }
  // ===========================

  set showMoreDetails(bool value) {
    _showMoreDetails = value;
    safeNotifyListeners();
  }

  ServiceComplaintBillListResponse? complaintBillListResponse;
  String? error;

  Future<void> serviceComplaintBillList(BuildContext context, String complaintId) async {
    try {
      var homeProvider = Provider.of<HomescreenNotifier>(context, listen: false);

      _isLoading = true;
      safeNotifyListeners();

      final data = await ApiCalling.serviceComplaintBillListAPI(
        homeProvider.empId,
        homeProvider.session,
        complaintId,
      );
      if (data != null) {
        if (data.error == 0) {
          _complaintList = data.complaintList ?? [];
          _isLoading = false;
          safeNotifyListeners();
        } else {
          toast(context, "Something Went Wrong, Please try again!");
        }
      } else {
        toast(context, "No response From the server, Please try Again!");
      }

      complaintBillListResponse = data;
      error = null;

    } catch (e) {
      error = e.toString();
      complaintBillListResponse = null;

    } finally {
      _isLoading = false;
      safeNotifyListeners();
    }
  }

  Future<void> LoadVisitDetailsAPI(BuildContext context, ComplaintID) async {
    try {
      var HomeProvider = Provider.of<HomescreenNotifier>(context, listen: false);

      final data = await ApiCalling.loadVisitDetailsAPI(
        HomeProvider.empId,
        HomeProvider.session,
        ComplaintID,
      );

      if (data != null) {
        if (data.error == 0) {
          _customerDetails = data.customerDetails!;
          _generatorDetails = data.generatorDetails!;
          _complaintDetailsNew = data.complaintDetailsNew!;
          _isLoading = false;
          safeNotifyListeners();
        } else {
          toast(context, "Something Went Wrong, Please try again!");
        }
      } else {
        toast(context, "No response From the server, Please try Again!");
      }
    } catch (e) {
      print(e.toString());
    }
  }

  Future<void> LoadFollowupListAPI(BuildContext context, ComplaintID) async {
    try {
      var HomeProvider = Provider.of<HomescreenNotifier>(context, listen: false);

      final data = await ApiCalling.loadFollowupListAPI(
        HomeProvider.empId,
        HomeProvider.session,
        ComplaintID,
      );

      if (data != null) {
        if (data.error == 0) {
          _followupList = data.list ?? [];
          _isLoading = false;
          safeNotifyListeners();
        } else {
          toast(context, "Something Went Wrong, Please try again!");
        }
      } else {
        toast(context, "No response From the server, Please try Again!");
      }
    } catch (e) {
      print(e.toString());
    }
  }

}

