class PendingTPCAgentListResponse {
  List<PendingTpcIssueList>? pendingTpcIssueList;
  String? error;
  String? message;

  PendingTPCAgentListResponse({
    this.pendingTpcIssueList,
    this.error,
    this.message,
  });

  PendingTPCAgentListResponse.fromJson(Map<String, dynamic> json) {
    if (json['pending_tpc_issue_list'] != null) {
      pendingTpcIssueList = <PendingTpcIssueList>[];
      json['pending_tpc_issue_list'].forEach((v) {
        pendingTpcIssueList!.add(PendingTpcIssueList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (pendingTpcIssueList != null) {
      data['pending_tpc_issue_list'] =
          pendingTpcIssueList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class PendingTpcIssueList {
  String? id;
  String? name;
  String? mobileNumber;
  String? idProofDirFilePath;
  String? idProofViewFileName;
  String? bankName;
  String? bankBeneficiaryName;
  String? bankAccountNo;
  String? bankIfscCode;
  String? note;
  String? enteredEmpId;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? tpcAgentId;
  String? aname;
  String? ename;
  String? orderId;
  String? totalAmount;
  String? paidAmount;
  String? orderNumber;
  String? level1TpcApprovedAmount;
  String? level2TpcApprovedAmount;
  String? status;
  String? tpcStatus;
  String? requestedTpcAmount;

  PendingTpcIssueList({
    this.id,
    this.name,
    this.mobileNumber,
    this.idProofDirFilePath,
    this.idProofViewFileName,
    this.bankName,
    this.bankBeneficiaryName,
    this.bankAccountNo,
    this.bankIfscCode,
    this.note,
    this.enteredEmpId,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.tpcAgentId,
    this.aname,
    this.ename,
    this.orderId,
    this.totalAmount,
    this.paidAmount,
    this.orderNumber,
    this.level1TpcApprovedAmount,
    this.level2TpcApprovedAmount,
    this.status,
    this.tpcStatus,
    this.requestedTpcAmount,
  });

  PendingTpcIssueList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    mobileNumber = json['mobile_number'];
    idProofDirFilePath = json['id_proof_dir_file_path'];
    idProofViewFileName = json['id_proof_view_file_name'];
    bankName = json['bank_name'];
    bankBeneficiaryName = json['bank_beneficiary_name'];
    bankAccountNo = json['bank_account_no'];
    bankIfscCode = json['bank_ifsc_code'];
    note = json['note'];
    enteredEmpId = json['entered_emp_id'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    tpcAgentId = json['tpc_agent_id'];
    aname = json['aname'];
    ename = json['ename'];
    orderId = json['order_id'];
    totalAmount = json['total_amount'];
    paidAmount = json['paid_amount'];
    orderNumber = json['order_number'];
    level1TpcApprovedAmount = json['level1_tpc_approved_amount'];
    level2TpcApprovedAmount = json['level2_tpc_approved_amount'];
    status = json['status'];
    tpcStatus = json['tpc_status'];
    requestedTpcAmount = json['requested_tpc_amount'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['mobile_number'] = mobileNumber;
    data['id_proof_dir_file_path'] = idProofDirFilePath;
    data['id_proof_view_file_name'] = idProofViewFileName;
    data['bank_name'] = bankName;
    data['bank_beneficiary_name'] = bankBeneficiaryName;
    data['bank_account_no'] = bankAccountNo;
    data['bank_ifsc_code'] = bankIfscCode;
    data['note'] = note;
    data['entered_emp_id'] = enteredEmpId;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['tpc_agent_id'] = tpcAgentId;
    data['aname'] = aname;
    data['ename'] = ename;
    data['order_id'] = orderId;
    data['total_amount'] = totalAmount;
    data['paid_amount'] = paidAmount;
    data['order_number'] = orderNumber;
    data['level1_tpc_approved_amount'] = level1TpcApprovedAmount;
    data['level2_tpc_approved_amount'] = level2TpcApprovedAmount;
    data['status'] = status;
    data['tpc_status'] = tpcStatus;
    data['requested_tpc_amount'] = requestedTpcAmount;
    return data;
  }
}
