class crmLeadDetailsEditAccountViewResponse {
  List<Teams>? teams;
  AccountDetails? accountDetails;
  String? error;
  String? message;

  crmLeadDetailsEditAccountViewResponse({
    this.teams,
    this.accountDetails,
    this.error,
    this.message,
  });

  crmLeadDetailsEditAccountViewResponse.fromJson(Map<String, dynamic> json) {
    if (json['teams'] != null) {
      teams = <Teams>[];
      json['teams'].forEach((v) {
        teams!.add(Teams.fromJson(v));
      });
    }
    accountDetails =
        json['account_details'] != null
            ? AccountDetails.fromJson(json['account_details'])
            : null;
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (teams != null) {
      data['teams'] = teams!.map((v) => v.toJson()).toList();
    }
    if (accountDetails != null) {
      data['account_details'] = accountDetails!.toJson();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class Teams {
  String? id;
  String? name;

  Teams({this.id, this.name});

  Teams.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class AccountDetails {
  String? team;
  String? segment;
  String? name;

  AccountDetails({this.team, this.segment, this.name});

  AccountDetails.fromJson(Map<String, dynamic> json) {
    team = json['team'];
    segment = json['segment'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['team'] = team;
    data['segment'] = segment;
    data['name'] = name;
    return data;
  }
}
