class LeadDetailsResponse {
  String? error;
  int? sessionExists;
  LeadDetails? leadDetails;
  AccountDetails? accountDetails;
  List<LeadProducts>? leadProducts;
  List<ContactDetails>? contactDetails;
  List<FollowupDetails>? followupDetails;
  List<AppointmentDetails>? appointmentDetails;
  List<QuotationsDetails>? quotationsDetails;
  String? message;
  String? showEditAccountButton;

  LeadDetailsResponse({
    this.error,
    this.sessionExists,
    this.leadDetails,
    this.accountDetails,
    this.leadProducts,
    this.contactDetails,
    this.followupDetails,
    this.appointmentDetails,
    this.quotationsDetails,
    this.message,
    this.showEditAccountButton,
  });

  LeadDetailsResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    sessionExists = json['session_exists'];
    leadDetails =
        json['lead_details'] != null
            ? LeadDetails.fromJson(json['lead_details'])
            : null;
    accountDetails =
        json['account_details'] != null
            ? AccountDetails.fromJson(json['account_details'])
            : null;
    if (json['lead_products'] != null) {
      leadProducts = <LeadProducts>[];
      json['lead_products'].forEach((v) {
        leadProducts!.add(LeadProducts.fromJson(v));
      });
    }
    if (json['contact_details'] != null) {
      contactDetails = <ContactDetails>[];
      json['contact_details'].forEach((v) {
        contactDetails!.add(ContactDetails.fromJson(v));
      });
    }
    if (json['followup_details'] != null) {
      followupDetails = <FollowupDetails>[];
      json['followup_details'].forEach((v) {
        followupDetails!.add(FollowupDetails.fromJson(v));
      });
    }
    if (json['appointment_details'] != null) {
      appointmentDetails = <AppointmentDetails>[];
      json['appointment_details'].forEach((v) {
        appointmentDetails!.add(AppointmentDetails.fromJson(v));
      });
    }
    if (json['quotations_details'] != null) {
      quotationsDetails = <QuotationsDetails>[];
      json['quotations_details'].forEach((v) {
        quotationsDetails!.add(QuotationsDetails.fromJson(v));
      });
    }
    message = json['message'];
    showEditAccountButton = json['show_edit_account_button'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    data['session_exists'] = sessionExists;
    if (leadDetails != null) {
      data['lead_details'] = leadDetails!.toJson();
    }
    if (accountDetails != null) {
      data['account_details'] = accountDetails!.toJson();
    }
    if (leadProducts != null) {
      data['lead_products'] = leadProducts!.map((v) => v.toJson()).toList();
    }
    if (contactDetails != null) {
      data['contact_details'] = contactDetails!.map((v) => v.toJson()).toList();
    }
    if (followupDetails != null) {
      data['followup_details'] =
          followupDetails!.map((v) => v.toJson()).toList();
    }
    if (appointmentDetails != null) {
      data['appointment_details'] =
          appointmentDetails!.map((v) => v.toJson()).toList();
    }
    if (quotationsDetails != null) {
      data['quotations_details'] =
          quotationsDetails!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    data['show_edit_account_button'] = showEditAccountButton;
    return data;
  }
}

class LeadDetails {
  String? id;
  String? ownerId;
  String? accId;
  String? accManagerId;
  String? status;
  String? openStatus;
  String? date;
  String? closeDate;
  String? closereason;
  String? competitor;
  String? orderGainId;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? followupFunction;
  String? name;
  String? contName;
  String? address;
  String? mob1;
  String? mob2;
  String? tel;
  String? email;
  String? prod;
  String? lage;
  String? copyMessage;

  LeadDetails({
    this.id,
    this.ownerId,
    this.accId,
    this.accManagerId,
    this.status,
    this.openStatus,
    this.date,
    this.closeDate,
    this.closereason,
    this.competitor,
    this.orderGainId,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.followupFunction,
    this.name,
    this.contName,
    this.address,
    this.mob1,
    this.mob2,
    this.tel,
    this.email,
    this.prod,
    this.lage,
    this.copyMessage,
  });

  LeadDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    ownerId = json['owner_id'];
    accId = json['acc_id'];
    accManagerId = json['acc_manager_id'];
    status = json['status'];
    openStatus = json['open_status'];
    date = json['date'];
    closeDate = json['close_date'];
    closereason = json['closereason'];
    competitor = json['competitor'];
    orderGainId = json['order_gain_id'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    followupFunction = json['followup_function'];
    name = json['name'];
    contName = json['cont_name'];
    address = json['address'];
    mob1 = json['mob1'];
    mob2 = json['mob2'];
    tel = json['tel'];
    email = json['email'];
    prod = json['prod'];
    lage = json['lage'];
    copyMessage = json['copy_message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['owner_id'] = ownerId;
    data['acc_id'] = accId;
    data['acc_manager_id'] = accManagerId;
    data['status'] = status;
    data['open_status'] = openStatus;
    data['date'] = date;
    data['close_date'] = closeDate;
    data['closereason'] = closereason;
    data['competitor'] = competitor;
    data['order_gain_id'] = orderGainId;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['followup_function'] = followupFunction;
    data['name'] = name;
    data['cont_name'] = contName;
    data['address'] = address;
    data['mob1'] = mob1;
    data['mob2'] = mob2;
    data['tel'] = tel;
    data['email'] = email;
    data['prod'] = prod;
    data['lage'] = lage;
    data['copy_message'] = copyMessage;
    return data;
  }
}

class AccountDetails {
  String? id;
  String? tempId;
  String? ownerId;
  String? accManagerId;
  String? name;
  String? salutationName;
  String? subLocality;
  String? district;
  String? state;
  String? pincode;
  String? address;
  String? date;
  String? source;
  String? reference;
  String? segment;
  String? team;
  String? gstNumber;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? email;
  String? mob1;
  String? accManager;
  String? owner;

  AccountDetails({
    this.id,
    this.tempId,
    this.ownerId,
    this.accManagerId,
    this.name,
    this.salutationName,
    this.subLocality,
    this.district,
    this.state,
    this.pincode,
    this.address,
    this.date,
    this.source,
    this.reference,
    this.segment,
    this.team,
    this.gstNumber,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.email,
    this.mob1,
    this.accManager,
    this.owner,
  });

  AccountDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    tempId = json['temp_id'];
    ownerId = json['owner_id'];
    accManagerId = json['acc_manager_id'];
    name = json['name'];
    salutationName = json['salutation_name'];
    subLocality = json['sub_locality'];
    district = json['district'];
    state = json['state'];
    pincode = json['pincode'];
    address = json['address'];
    date = json['date'];
    source = json['source'];
    reference = json['reference'];
    segment = json['segment'];
    team = json['team'];
    gstNumber = json['gst_number'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    email = json['email'];
    mob1 = json['mob1'];
    accManager = json['acc_manager'];
    owner = json['owner'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['temp_id'] = tempId;
    data['owner_id'] = ownerId;
    data['acc_manager_id'] = accManagerId;
    data['name'] = name;
    data['salutation_name'] = salutationName;
    data['sub_locality'] = subLocality;
    data['district'] = district;
    data['state'] = state;
    data['pincode'] = pincode;
    data['address'] = address;
    data['date'] = date;
    data['source'] = source;
    data['reference'] = reference;
    data['segment'] = segment;
    data['team'] = team;
    data['gst_number'] = gstNumber;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['email'] = email;
    data['mob1'] = mob1;
    data['acc_manager'] = accManager;
    data['owner'] = owner;
    return data;
  }
}

class LeadProducts {
  String? id;
  String? leadId;
  String? productId;
  String? qty;
  String? price;
  String? prodTotalPrice;
  String? date;
  String? isDel;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? productName;
  String? remarks;

  LeadProducts({
    this.id,
    this.leadId,
    this.productId,
    this.qty,
    this.price,
    this.prodTotalPrice,
    this.date,
    this.isDel,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.productName,
    this.remarks
  });

  LeadProducts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    leadId = json['lead_id'];
    productId = json['product_id'];
    qty = json['qty'];
    price = json['price'];
    prodTotalPrice = json['prod_total_price'];
    date = json['date'];
    isDel = json['is_del'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    productName = json['product_name'];
    remarks = json['remarks'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['lead_id'] = leadId;
    data['product_id'] = productId;
    data['qty'] = qty;
    data['price'] = price;
    data['prod_total_price'] = prodTotalPrice;
    data['date'] = date;
    data['is_del'] = isDel;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['product_name'] = productName;
    data['remarks'] = remarks;
    return data;
  }
}

class ContactDetails {
  String? id;
  String? accId;
  String? name;
  String? salutationName;
  String? mob1;
  String? mob2;
  String? tel;
  String? email;
  String? type;
  String? designation;
  String? date;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  ContactDetails({
    this.id,
    this.accId,
    this.name,
    this.salutationName,
    this.mob1,
    this.mob2,
    this.tel,
    this.email,
    this.type,
    this.designation,
    this.date,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  ContactDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    accId = json['acc_id'];
    name = json['name'];
    salutationName = json['salutation_name'];
    mob1 = json['mob1'];
    mob2 = json['mob2'];
    tel = json['tel'];
    email = json['email'];
    type = json['type'];
    designation = json['designation'];
    date = json['date'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['acc_id'] = accId;
    data['name'] = name;
    data['salutation_name'] = salutationName;
    data['mob1'] = mob1;
    data['mob2'] = mob2;
    data['tel'] = tel;
    data['email'] = email;
    data['type'] = type;
    data['designation'] = designation;
    data['date'] = date;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}

class FollowupDetails {
  String? ename;
  String? ftype;
  String? fdate;
  String? finTime;
  String? foutTime;
  String? fstatus;
  String? ffeedback;

  FollowupDetails({
    this.ename,
    this.ftype,
    this.fdate,
    this.finTime,
    this.foutTime,
    this.fstatus,
    this.ffeedback,
  });

  FollowupDetails.fromJson(Map<String, dynamic> json) {
    ename = json['ename'];
    ftype = json['ftype'];
    fdate = json['fdate'];
    finTime = json['fin_time'];
    foutTime = json['fout_time'];
    fstatus = json['fstatus'];
    ffeedback = json['ffeedback'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['ename'] = ename;
    data['ftype'] = ftype;
    data['fdate'] = fdate;
    data['fin_time'] = finTime;
    data['fout_time'] = foutTime;
    data['fstatus'] = fstatus;
    data['ffeedback'] = ffeedback;
    return data;
  }
}

class AppointmentDetails {
  String? ename;
  String? aappDate;
  String? atype;
  String? anote;
  String? astatus;
  String? adate;

  AppointmentDetails({
    this.ename,
    this.aappDate,
    this.atype,
    this.anote,
    this.astatus,
    this.adate,
  });

  AppointmentDetails.fromJson(Map<String, dynamic> json) {
    ename = json['ename'];
    aappDate = json['aapp_date'];
    atype = json['atype'];
    anote = json['anote'];
    astatus = json['astatus'];
    adate = json['adate'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['ename'] = ename;
    data['aapp_date'] = aappDate;
    data['atype'] = atype;
    data['anote'] = anote;
    data['astatus'] = astatus;
    data['adate'] = adate;
    return data;
  }
}

class QuotationsDetails {
  String? id;
  String? empId;
  String? leadId;
  String? email;
  String? mobile;
  String? quote;
  String? info;
  String? type;
  String? quoteType;
  String? subject;
  String? taxes;
  String? spclNote;
  String? forTxt;
  String? payTerms;
  String? priceShead;
  String? extraChargeNarr;
  String? extraChargeAmount;
  String? transportCharge;
  String? loadUnloadCharge;
  String? minDuration;
  String? deliveryPeriod;
  String? minAdvance;
  String? extraHoursCharge;
  String? date;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? employee;

  QuotationsDetails({
    this.id,
    this.empId,
    this.leadId,
    this.email,
    this.mobile,
    this.quote,
    this.info,
    this.type,
    this.quoteType,
    this.subject,
    this.taxes,
    this.spclNote,
    this.forTxt,
    this.payTerms,
    this.priceShead,
    this.extraChargeNarr,
    this.extraChargeAmount,
    this.transportCharge,
    this.loadUnloadCharge,
    this.minDuration,
    this.deliveryPeriod,
    this.minAdvance,
    this.extraHoursCharge,
    this.date,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.employee,
  });

  QuotationsDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    empId = json['emp_id'];
    leadId = json['lead_id'];
    email = json['email'];
    mobile = json['mobile'];
    quote = json['quote'];
    info = json['info'];
    type = json['type'];
    quoteType = json['quote_type'];
    subject = json['subject'];
    taxes = json['taxes'];
    spclNote = json['spcl_note'];
    forTxt = json['for_txt'];
    payTerms = json['pay_terms'];
    priceShead = json['price_shead'];
    extraChargeNarr = json['extra_charge_narr'];
    extraChargeAmount = json['extra_charge_amount'];
    transportCharge = json['transport_charge'];
    loadUnloadCharge = json['load_unload_charge'];
    minDuration = json['min_duration'];
    deliveryPeriod = json['delivery_period'];
    minAdvance = json['min_advance'];
    extraHoursCharge = json['extra_hours_charge'];
    date = json['date'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    employee = json['employee'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['emp_id'] = empId;
    data['lead_id'] = leadId;
    data['email'] = email;
    data['mobile'] = mobile;
    data['quote'] = quote;
    data['info'] = info;
    data['type'] = type;
    data['quote_type'] = quoteType;
    data['subject'] = subject;
    data['taxes'] = taxes;
    data['spcl_note'] = spclNote;
    data['for_txt'] = forTxt;
    data['pay_terms'] = payTerms;
    data['price_shead'] = priceShead;
    data['extra_charge_narr'] = extraChargeNarr;
    data['extra_charge_amount'] = extraChargeAmount;
    data['transport_charge'] = transportCharge;
    data['load_unload_charge'] = loadUnloadCharge;
    data['min_duration'] = minDuration;
    data['delivery_period'] = deliveryPeriod;
    data['min_advance'] = minAdvance;
    data['extra_hours_charge'] = extraHoursCharge;
    data['date'] = date;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['employee'] = employee;
    return data;
  }
}
