class commonAccessiblePagesResponse {
  String? error;
  List<PagesAccessible>? pagesAccessible;
  String? message;

  commonAccessiblePagesResponse({
    this.error,
    this.pagesAccessible,
    this.message,
  });

  commonAccessiblePagesResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['pages_accessible'] != null) {
      pagesAccessible = <PagesAccessible>[];
      json['pages_accessible'].forEach((v) {
        pagesAccessible!.add(PagesAccessible.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (pagesAccessible != null) {
      data['pages_accessible'] =
          pagesAccessible!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    return data;
  }
}

class PagesAccessible {
  int? id;
  String? pageName;
  String? mode;

  PagesAccessible({this.id, this.pageName, this.mode});

  PagesAccessible.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    pageName = json['page_name'];
    mode = json['mode'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['page_name'] = pageName;
    data['mode'] = mode;
    return data;
  }
}
