import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/crmProvider/addNewLeadsandProspectsProvider.dart';
import 'package:generp/screens/crm/addLeadsProspectsScreen.dart';
import 'package:generp/screens/crm/appointmentCalendar.dart';
import 'package:generp/screens/crm/followUpListonType.dart';
import 'package:generp/screens/crm/generatedQuotesList.dart';
import 'package:generp/screens/crm/pendingTasksDetails.dart';
import 'package:generp/screens/crm/pendingTasksList.dart';
import 'package:generp/screens/crm/universalSearchScreen.dart';

import 'package:provider/provider.dart';
import 'package:generp/screens/screensExports.dart';
import '../../Notifiers/crmProvider/crmDashboardProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonServices.dart';
import '../../Utils/commonWidgets.dart';

class CrmdashboardScreen extends StatefulWidget {
  const CrmdashboardScreen({super.key});

  @override
  State<CrmdashboardScreen> createState() => _CrmdashboardScreenState();
}

class _CrmdashboardScreenState extends State<CrmdashboardScreen> {
  FocusNode focusNode = FocusNode();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((event) {
      setState(() => _source = event);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var prov = Provider.of<Crmdashboardprovider>(context, listen: false);
      prov.getCurrentLocation(context);
      prov.accessPagesAPIFunction(context);
      // prov.crmDashboardAPIFunction(context);
      prov.crmPendingTasksAPIFunction(context);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Crmdashboardprovider>(
      builder: (context, provider, child) {
        final gridPages =
            provider.accessPages
                .where((page) => ![8, 9, 23, 24, 51, 50].contains(page.id))
                .toList();

        return Scaffold(
          resizeToAvoidBottomInset: true,
          backgroundColor: AppColors.scaffold_bg_color,
          appBar: AppBar(
            automaticallyImplyLeading: false,
            // elevation: 2.0,
            title: SizedBox(
              child: Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  InkResponse(
                    onTap: () {
                      HapticFeedback.selectionClick();
                      Navigator.pop(context, true);
                    },

                    child: SvgPicture.asset(
                      "assets/svg/appbar_back_button.svg",
                      height: 25,
                    ),
                  ),
                  SizedBox(width: 10),
                  InkResponse(
                    onTap: () {
                      HapticFeedback.selectionClick();
                      Navigator.pop(context, true);
                    },
                    child: Text(
                      "CRM",
                      style: TextStyle(
                        fontSize: 16,
                        height: 1.1,
                        fontFamily: "JakartaSemiBold",
                        color: AppColors.semi_black,
                      ),
                    ),
                  ),
                ],
              ),
            ),
            bottom: PreferredSize(
              preferredSize: Size.fromHeight(50),
              child: InkResponse(
                onTap: () {
                  HapticFeedback.selectionClick();
                  print("Tap");
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder:
                          (context) => Universalsearchscreen(
                            text: provider.searchController.text,
                          ),
                      settings: RouteSettings(name: 'SearchScreen'),
                    ),
                  );
                },
                child: Container(
                  padding: const EdgeInsets.fromLTRB(5.0, 0.0, 10, 0),
                  margin: const EdgeInsets.fromLTRB(10.0, 0.0, 10, 10),
                  height: 50,
                  alignment: Alignment.center,
                  decoration: BoxDecoration(
                    color: AppColors.text_field_color,
                    borderRadius: BorderRadius.circular(14),
                  ),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Expanded(
                        child: Container(
                          alignment: Alignment.centerLeft,

                          child: Text(
                            "Search By Name/Mobile",
                            style: TextStyle(
                              height: 1,
                              color: AppColors.grey_thick,
                              fontSize: 14,
                            ),
                          ),
                        ),
                      ),
                      SvgPicture.asset("assets/svg/search_ic.svg"),
                    ],
                  ),
                ),
              ),
            ),
            // shape: RoundedRectangleBorder(
            //   borderRadius: BorderRadius.vertical(
            //     bottom: Radius.circular(30), // Adjust the radius as needed
            //   ),
            // ),
          ),
          body: SingleChildScrollView(
            physics: AlwaysScrollableScrollPhysics(),
            child: Column(
              children: [
                if (provider.allLeads.isNotEmpty) ...[
                  Container(
                    padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                    margin: EdgeInsets.only(bottom: 10),
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.vertical(
                        bottom: Radius.circular(16),
                      ),
                    ),
                    height: MediaQuery.of(context).size.height * 0.25,
                    child: GridView.builder(
                      padding: EdgeInsets.symmetric(horizontal: 0, vertical: 5),
                      itemCount: provider.allLeads.length,
                      shrinkWrap: true,
                      scrollDirection: Axis.horizontal,
                      physics: AlwaysScrollableScrollPhysics(),
                      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                        crossAxisCount: 2,
                        crossAxisSpacing: 10,
                        mainAxisSpacing: 10,
                        childAspectRatio: 55 / 100,
                      ),
                      itemBuilder: (context, jndex) {
                        final icons = ["comm_ic_1", "comm_ic_2"];
                        final leadTitles = [
                          'Open Leads',
                          'Quotation Generated',
                          'Pending Tasks',
                          'Today Visits',
                          'Today Calls',
                          'Hot Leads',
                          'Cold Leads',
                          'Warm Leads',
                          // 'Total Leads',
                          // 'Order Lost',
                          // 'No Requirement',
                          // 'Open Enquiries',
                        ];
                        final assetNames = [
                          "assets/svg/crm/open_leads_ic.svg",
                          "assets/svg/crm/quotes_generated_ic.svg",
                          "assets/svg/crm/pending_tasks_ic.svg",
                          "assets/svg/crm/today_visits_ic.svg",
                          "assets/svg/crm/today_calls_ic.svg",
                          "assets/svg/crm/hot_leads_ic.svg",
                          "assets/svg/crm/cold_leads_ic.svg",
                          "assets/svg/crm/warm_leads_ic.svg",
                        ];
                        final colors = [
                          0xFFE7FFE5,
                          0xFFF3EDFF,
                          0xFFEEF1FF,
                          0xFFFFFCD5,
                          0xFFFFF6F0,
                          0xFFFFEFEF,
                          0xFFEDF7FF,
                          0xFFFFF1CE,
                        ];
                        final textcolors = [
                          0xFF0D9C00,
                          0xFF493272,
                          0xFF6563FF,
                          0xFF605C00,
                          0xFF91481B,
                          0xFFED3424,
                          0xFF326D72,
                          0xFF586000,
                        ];

                        return InkResponse(
                          onTap: () async {
                            HapticFeedback.selectionClick();
                            if (provider.allLeads[jndex].filter!.pageName !=
                                "") {
                              if (provider.allLeads[jndex].filter!.pageName!
                                  .contains("Lead List")) {
                                await Navigator.push(
                                  context,
                                  MaterialPageRoute(
                                    builder:
                                        (context) => Leadlistbymode(
                                          pageTitleName: leadTitles[jndex],
                                          mode:
                                              provider
                                                  .allLeads[jndex]
                                                  .filter!
                                                  .mode,
                                          filter:
                                              provider.allLeads[jndex].filter!,
                                        ),
                                  ),
                                );
                              }
                            }
                            if (leadTitles[jndex] == "Pending Tasks") {
                              await Navigator.push(
                                context,
                                MaterialPageRoute(
                                  builder: (context) => PendingTasksList(),
                                  settings: RouteSettings(
                                    name: "PendingTasksList",
                                  ),
                                ),
                              );
                            }

                            if (leadTitles[jndex] == "Quotation Generated") {
                              await Navigator.push(
                                context,
                                MaterialPageRoute(
                                  builder: (context) => Generatedquoteslist(),
                                  settings: RouteSettings(
                                    name: "Generatedquoteslist",
                                  ),
                                ),
                              );
                            }

                            if (leadTitles[jndex] == "Today Visits") {
                              await Navigator.push(
                                context,
                                MaterialPageRoute(
                                  builder:
                                      (context) =>
                                          Followuplistontype(type: "Visit"),
                                  settings: RouteSettings(
                                    name: "Generatedquoteslist",
                                  ),
                                ),
                              );
                            }
                            if (leadTitles[jndex] == "Today Calls") {
                              await Navigator.push(
                                context,
                                MaterialPageRoute(
                                  builder:
                                      (context) =>
                                          Followuplistontype(type: "Phone"),
                                  settings: RouteSettings(
                                    name: "Generatedquoteslist",
                                  ),
                                ),
                              );
                            }
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(horizontal: 13),
                            decoration: BoxDecoration(
                              color: Color(colors[jndex]),
                              borderRadius: BorderRadius.circular(20),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Text(
                                  provider.allLeads[jndex].count.toString(),
                                  style: TextStyle(
                                    fontSize: 20,
                                    fontFamily: "JakartaMedium",
                                    color: Color(textcolors[jndex]),
                                  ),
                                ),
                                Row(
                                  children: [
                                    Expanded(
                                      flex: 3,
                                      child: Text(
                                        leadTitles[jndex],
                                        style: TextStyle(
                                          fontSize: 14,
                                          fontFamily: "JakartaRegular",
                                          color: AppColors.semi_black,
                                        ),
                                      ),
                                    ),
                                    Expanded(
                                      flex: 1,
                                      child: SvgPicture.asset(
                                        assetNames[jndex],
                                      ),
                                    ),
                                  ],
                                ),
                              ],
                            ),
                          ),
                        );
                      },
                    ),
                  ),
                ] else ...[
                  SizedBox(height: 10),
                ],

                // ListView.builder(
                //   physics: NeverScrollableScrollPhysics(),
                //   shrinkWrap: true,
                //   padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                //   itemCount: gridPages.length,
                //   itemBuilder: (context, index) {
                //     // final icons = ["comm_ic_1", "comm_ic_2"];
                //     Widget? SvgIcon;
                //
                //     if (gridPages[index].pageName!.contains("Lead List")) {
                //       SvgIcon = SvgPicture.asset("assets/svg/fin_lv1.svg");
                //     } else if (gridPages[index].pageName == "Nearby Leads") {
                //       SvgIcon = SvgPicture.asset(
                //         "assets/svg/home_icons_5.svg",
                //         height: 18,
                //         width: 18,
                //       );
                //     } else {
                //       SvgIcon = SvgPicture.asset("assets/svg/fin_ic.svg");
                //     }
                //     return InkResponse(
                //       onTap: () {
                //         print(gridPages[index].pageName!);
                //         if (gridPages[index].pageName!.contains("Lead List")) {
                //           Navigator.push(
                //             context,
                //             MaterialPageRoute(
                //               builder:
                //                   (context) => Leadlistbymode(
                //                     mode: gridPages[index].mode,
                //                     pageTitleName: gridPages[index].pageName,
                //                   ),
                //             ),
                //           );
                //         } else if (gridPages[index].pageName!.contains(
                //           "Account List",
                //         )) {
                //           Navigator.push(
                //             context,
                //             MaterialPageRoute(
                //               builder:
                //                   (context) => ProspectListByMode(
                //                     mode: gridPages[index].mode,
                //                     pageTitleName: gridPages[index].pageName,
                //                   ),
                //             ),
                //           );
                //         } else if (gridPages[index].pageName ==
                //             "Nearby Leads") {
                //           Navigator.push(
                //             context,
                //             MaterialPageRoute(
                //               builder: (context) => NearbyOpenLeads(),
                //             ),
                //           );
                //         }
                //         // switch (gridPages[index].pageName!) {
                //         //   case "Lead List":
                //         //     Navigator.push(
                //         //       context,
                //         //       MaterialPageRoute(builder: (context) => Leadlistbymode()),
                //         //     );
                //         //     break;
                //         //   case "Prospect List":
                //         //     // Navigator.push(
                //         //     //   context,
                //         //     //   MaterialPageRoute(builder: (context) => Accountledger()),
                //         //     // );
                //         //     break;
                //         //
                //         //   default:
                //         //     print("111");
                //         //     break;
                //         // }
                //       },
                //       child: Container(
                //         decoration: BoxDecoration(
                //           color: Colors.white,
                //           borderRadius: BorderRadius.circular(14),
                //         ),
                //         margin: EdgeInsets.symmetric(
                //           horizontal: 5,
                //           vertical: 5,
                //         ),
                //         padding: EdgeInsets.symmetric(
                //           horizontal: 10,
                //           vertical: 15,
                //         ),
                //         child: Row(
                //           children: [
                //             Expanded(flex: 1, child: SvgIcon),
                //
                //             Expanded(
                //               flex: 5,
                //               child: Text(
                //                 "${gridPages[index].pageName}",
                //                 style: TextStyle(fontSize: 14),
                //               ),
                //             ),
                //             Expanded(
                //               flex: 1,
                //               child: SvgPicture.asset(
                //                 "assets/svg/arrow_right_new.svg",
                //               ),
                //             ),
                //           ],
                //         ),
                //       ),
                //     );
                //   },
                // ),
                Container(
                  height: MediaQuery.of(context).size.height * 0.25,
                  margin: EdgeInsets.symmetric(horizontal: 10),
                  child: Row(
                    children: [
                      Expanded(
                        child: Column(
                          children: [
                            Expanded(
                              child: Container(
                                padding: EdgeInsets.symmetric(horizontal: 5),
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(20),
                                ),
                                child: Row(
                                  children: [
                                    Expanded(
                                      flex: 2,
                                      child: InkResponse(
                                        onTap: () {
                                          HapticFeedback.selectionClick();
                                          Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) => Leadlistbymode(
                                                    mode: "executive",
                                                    pageTitleName: "Lead List",
                                                  ),
                                            ),
                                          );
                                        },
                                        child: Container(
                                          padding: EdgeInsets.only(
                                            top: 15,
                                            left: 10,
                                          ),
                                          child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Text(
                                                "Lead List",
                                                style: TextStyle(
                                                  color: AppColors.app_blue,
                                                  fontSize: 14,
                                                ),
                                              ),
                                              Text(
                                                "Appointments,\nFollowups",
                                                // "Product and \nservice orders",
                                                style: TextStyle(
                                                  color: AppColors.grey_semi,
                                                  fontSize: 12,
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                    ),
                                    Expanded(
                                      child: SvgPicture.asset(
                                        "assets/svg/crm/lead_list_ic.svg",
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                            SizedBox(height: 10),
                            Expanded(
                              child: Container(
                                padding: EdgeInsets.symmetric(horizontal: 5),
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(20),
                                ),
                                child: Row(
                                  children: [
                                    Expanded(
                                      flex: 2,
                                      child: InkResponse(
                                        onTap: () {
                                          HapticFeedback.selectionClick();
                                          Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) =>
                                                      ProspectListByMode(
                                                        mode: "executive",
                                                        pageTitleName:
                                                            "Account List",
                                                      ),
                                            ),
                                          );
                                        },
                                        child: Container(
                                          padding: EdgeInsets.only(
                                            top: 15,
                                            left: 10,
                                          ),
                                          child: Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Text(
                                                "Account List",
                                                style: TextStyle(
                                                  color: AppColors.app_blue,
                                                  fontSize: 14,
                                                ),
                                              ),
                                              Text(
                                                "Account Details,\nLead Details",
                                                // "Assigned agents, \nperformance",
                                                style: TextStyle(
                                                  color: AppColors.grey_semi,
                                                  fontSize: 12,
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                    ),
                                    Expanded(
                                      child: SvgPicture.asset(
                                        "assets/svg/crm/account_list_ic.svg",
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                      SizedBox(width: 10),
                      Expanded(
                        child: InkResponse(
                          onTap: () async {
                            HapticFeedback.selectionClick();
                            await Navigator.push(
                              context,
                              MaterialPageRoute(
                                builder: (context) => Appointmentcalendar(),
                                settings: RouteSettings(
                                  name: 'Appointmentcalendar',
                                ),
                              ),
                            );
                          },

                          child: Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 15,
                              vertical: 15,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(20),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: [
                                Expanded(
                                  child: Row(
                                    children: [
                                      Expanded(
                                        child: Text(
                                          "Appointment\nCalendar",
                                          style: TextStyle(
                                            color: AppColors.app_blue,
                                            fontSize: 14,
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                                Text(
                                  "",
                                  // "Records,\nLedger",
                                  style: TextStyle(
                                    color: AppColors.grey_semi,
                                    fontSize: 12,
                                  ),
                                ),
                                Spacer(),
                                Expanded(
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.end,
                                    crossAxisAlignment: CrossAxisAlignment.end,
                                    children: [
                                      SvgPicture.asset(
                                        "assets/svg/crm/appointment_calendar_ic.svg",
                                      ),
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                ),

                if (provider.nearByLeads.isNotEmpty) ...[
                  Align(
                    alignment: Alignment.centerLeft,
                    child: Padding(
                      padding: EdgeInsets.only(left: 15, top: 10, right: 15),
                      child: Row(
                        children: [
                          Text(
                            "Nearby Leads",
                            style: TextStyle(
                              fontSize: 16,
                              color: AppColors.grey_semi,
                            ),
                          ),
                          Spacer(),
                          InkResponse(
                            onTap: () async {
                              HapticFeedback.selectionClick();
                              await Navigator.push(
                                context,
                                MaterialPageRoute(
                                  builder: (context) => NearbyOpenLeads(),
                                  settings: RouteSettings(
                                    name: "NearbyOpenLeads",
                                  ),
                                ),
                              );
                            },
                            child: SizedBox(
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Text(
                                    "View All",
                                    style: TextStyle(
                                      fontFamily: "JakartaMedium",
                                      fontSize: 14,
                                      color: AppColors.app_blue,
                                    ),
                                  ),
                                  SizedBox(width: 5),
                                  SvgPicture.asset(
                                    "assets/svg/next_button.svg",
                                  ),
                                ],
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                  SizedBox(
                    width: double.infinity,
                    height: 150,
                    child: ListView.builder(
                      physics: AlwaysScrollableScrollPhysics(),
                      shrinkWrap: true,
                      scrollDirection: Axis.horizontal,
                      padding: EdgeInsets.symmetric(
                        vertical: 10,
                        horizontal: 10,
                      ),
                      itemCount: provider.nearByLeads.length,
                      itemBuilder: (context, index) {
                        final lead = provider.nearByLeads[index];
                        final location = provider.parseLocation(lead.loc!);
                        final latitude = location.lat;
                        final longitude = location.lng;
                        return InkResponse(
                          onTap: () async {
                            HapticFeedback.selectionClick();
                            Navigator.push(
                              context,
                              MaterialPageRoute(
                                builder:
                                    (context) => LeadDetailsByMode(
                                      mode: "",
                                      pageTitleName: "Lead Details",
                                      leadId: provider.nearByLeads[index].id,
                                    ),
                              ),
                            );
                          },
                          child: Container(
                            alignment: Alignment.center,
                            height: 150,
                            width: MediaQuery.of(context).size.width * 0.8,
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(14),
                            ),
                            margin: EdgeInsets.symmetric(
                              horizontal: 5,
                              vertical: 5,
                            ),
                            padding: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 15,
                            ),
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Expanded(
                                  child: Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Text(
                                        provider.nearByLeads[index].name ?? "-",
                                        maxLines: 1,
                                        style: TextStyle(
                                          fontSize: 14,
                                          color: AppColors.semi_black,
                                          fontFamily: "JakartaMedium",
                                        ),
                                      ),
                                      Text(
                                        provider.nearByLeads[index].product ??
                                            "-",
                                        maxLines: 2,
                                        style: TextStyle(
                                          fontSize: 14,
                                          color: AppColors.grey_semi,
                                          fontFamily: "JakartaMedium",
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(
                                  child: InkResponse(
                                    onTap: () async {
                                      HapticFeedback.selectionClick();
                                      await Navigator.push(
                                        context,
                                        MaterialPageRoute(
                                          builder:
                                              (context) => NearbyOpenLeads(
                                                latitude: latitude,
                                                longitude: longitude,
                                              ),
                                          settings: RouteSettings(
                                            name: "NearbyOpenLeads",
                                          ),
                                        ),
                                      );
                                    },
                                    child: Container(
                                      decoration: BoxDecoration(
                                        border: Border.all(
                                          color: AppColors.semi_black.withAlpha(
                                            10,
                                          ),
                                        ),
                                        borderRadius: BorderRadius.circular(16),
                                      ),
                                      child: ClipRRect(
                                        borderRadius: BorderRadius.circular(16),
                                        child: Image.network(
                                          provider.getSimpleOSMImage(
                                            latitude,
                                            longitude,
                                          ),
                                          width: 400,
                                          height: 400,
                                          fit: BoxFit.cover,
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                        );
                      },
                    ),
                  ),
                ] else ...[
                  SizedBox(height: 10),
                  InkResponse(
                    onTap: () {
                      HapticFeedback.selectionClick();
                      Navigator.push(
                        context,
                        MaterialPageRoute(
                          builder: (context) => NearbyOpenLeads(),
                        ),
                      );
                    },
                    child: Container(
                      height: 60,
                      margin: EdgeInsets.symmetric(horizontal: 10, vertical: 0),
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(20),
                      ),

                      child: Row(
                        children: [
                          Expanded(
                            flex: 1,
                            child: Container(
                              height: 35,
                              width: 35,
                              padding: EdgeInsets.all(8.0),

                              decoration: BoxDecoration(
                                color: Color(0xFFEDF8FF),
                                shape: BoxShape.circle,
                              ),
                              child: SvgPicture.asset(
                                "assets/svg/find_generator.svg",
                              ),
                            ),
                          ),
                          Expanded(
                            flex: 4,
                            child: Text(
                              "Find Nearby Leads",
                              style: TextStyle(
                                fontSize: 14,
                                color: AppColors.app_blue,
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ],

                if (provider.pendingTasksLists.isNotEmpty) ...[
                  Align(
                    alignment: Alignment.centerLeft,
                    child: Padding(
                      padding: EdgeInsets.only(left: 15, top: 10, right: 15),
                      child: Row(
                        children: [
                          Text(
                            "Pending Tasks",
                            style: TextStyle(
                              fontSize: 16,
                              color: AppColors.grey_semi,
                            ),
                          ),
                          if (provider.pendingTasksLists.length > 5) ...[
                            Spacer(),
                            InkResponse(
                              onTap: () async {
                                HapticFeedback.selectionClick();
                                await Navigator.push(
                                  context,
                                  MaterialPageRoute(
                                    builder: (context) => PendingTasksList(),
                                    settings: RouteSettings(
                                      name: "PendingTasksList",
                                    ),
                                  ),
                                );
                              },
                              child: SizedBox(
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  children: [
                                    Text(
                                      "View All",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                    SizedBox(width: 5),
                                    SvgPicture.asset(
                                      "assets/svg/next_button.svg",
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ],
                        ],
                      ),
                    ),
                  ),
                  SizedBox(
                    width: double.infinity,
                    child: ListView.builder(
                      physics: NeverScrollableScrollPhysics(),
                      shrinkWrap: true,
                      padding: EdgeInsets.symmetric(
                        vertical: 5,
                        horizontal: 10,
                      ),
                      // itemCount: provider.pendingTasksLists.length,
                      itemCount:
                          provider.pendingTasksLists.length > 5
                              ? 5
                              : provider.pendingTasksLists.length,
                      itemBuilder: (context, index) {
                        final subHeadings = [
                          provider.pendingTasksLists[index].aname ?? "-",
                          provider.pendingTasksLists[index].appdate ?? "-",
                          provider.pendingTasksLists[index].anote ?? "-",
                        ];
                        return InkResponse(
                          onTap: () async {
                            HapticFeedback.selectionClick();
                            await Navigator.push(
                              context,
                              MaterialPageRoute(
                                builder:
                                    (context) =>
                                        Pendingtasksdetails(detailIndex: index),
                                settings: RouteSettings(
                                  name: 'Pendingtasksdetails',
                                ),
                              ),
                            );
                          },
                          child: Container(
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(15),
                            ),
                            margin: EdgeInsets.symmetric(vertical: 3),
                            padding: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 5,
                            ),
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: [
                                Container(
                                  padding: EdgeInsets.symmetric(
                                    vertical: 3,
                                    horizontal: 0,
                                  ),

                                  child: Column(
                                    children: [
                                      Row(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Expanded(
                                            child: Text(
                                              "${provider.pendingTasksLists[index].aname}",
                                              maxLines: 1,
                                              overflow: TextOverflow.visible,
                                              style: TextStyle(
                                                decoration:
                                                    TextDecoration.underline,
                                                height: 1,
                                                decorationStyle:
                                                    TextDecorationStyle.dotted,
                                                decorationColor: Color(
                                                  0xFF676767,
                                                ),
                                                color: AppColors.semi_black,
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            child: Text(
                                              "${provider.pendingTasksLists[index].appdate}",
                                              textAlign: TextAlign.right,
                                              maxLines: 1,

                                              style: TextStyle(
                                                color: AppColors.grey_semi,
                                                fontFamily: "JakartaRegular",
                                                fontSize: 14,
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                      SizedBox(height: 10),
                                      Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 10,
                                          horizontal: 10,
                                        ),
                                        decoration: BoxDecoration(
                                          borderRadius: BorderRadius.circular(
                                            16,
                                          ),
                                          gradient: LinearGradient(
                                            colors: [
                                              Color(0xFFFFFFFF),
                                              Color(0xFFE8F7FF),
                                            ],
                                          ),
                                        ),
                                        child: Row(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Expanded(
                                              child: Text(
                                                "Remarks",
                                                maxLines: 1,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  color: AppColors.app_blue,
                                                  fontFamily: "JakartaRegular",
                                                  fontSize: 14,
                                                ),
                                              ),
                                            ),
                                            Expanded(
                                              child: Text(
                                                "${provider.pendingTasksLists[index].anote}",
                                                textAlign: TextAlign.right,
                                                maxLines: 2,
                                                overflow: TextOverflow.ellipsis,
                                                style: TextStyle(
                                                  color: AppColors.semi_black,
                                                  fontFamily: "JakartaRegular",
                                                  fontSize: 14,
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ),
                        );
                      },
                    ),
                  ),
                ],
                SizedBox(height: 150),
              ],
            ),
          ),
          floatingActionButtonLocation:
              FloatingActionButtonLocation.centerFloat,
          floatingActionButton:
              provider.accessPages.any((element) => [8, 9].contains(element.id))
                  ? InkResponse(
                    onTap: () async {
                      // if (provider.accessPages
                      //     .where((page) => [8, 9].contains(page.id))
                      //     .toList()
                      //     .contains([8, 9])) {
                      await Navigator.push(
                        context,
                        MaterialPageRoute(
                          builder: (context) => Addleadsprospectsscreen(),
                          settings: RouteSettings(
                            name: 'Addleadsprospectsscreen',
                          ),
                        ),
                      );
                      // }
                    },
                    child: Container(
                      height: 45,
                      alignment: Alignment.center,
                      margin: EdgeInsets.symmetric(horizontal: 10),
                      padding: EdgeInsets.symmetric(
                        horizontal: 10,
                        vertical: 5,
                      ),
                      decoration: BoxDecoration(
                        color: AppColors.app_blue,
                        borderRadius: BorderRadius.circular(15),
                      ),
                      child: Text(
                        "Add Leads and Prospect",
                        style: TextStyle(
                          fontSize: 15,
                          fontFamily: "JakartaMedium",
                          color: Colors.white,
                        ),
                      ),
                    ),
                  )
                  : SizedBox.shrink(),
        );
      },
    );
  }

  Future<void> _showPaymentOptionsSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Crmdashboardprovider>(
                builder: (context, provider, child) {
                  final accessiblePagesList =
                      provider.accessPages
                          .where((page) => [8, 9].contains(page.id))
                          .toList();
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),

                          ...List.generate(accessiblePagesList.length, (index) {
                            print(accessiblePagesList[index].mode);

                            return ListTile(
                              onTap: () async {
                                Navigator.pop(context);
                                var res;
                              },
                              leading: SvgPicture.asset(
                                "assets/svg/fin_ic.svg",
                              ),
                              title: Text(
                                "${accessiblePagesList[index].pageName}",
                                style: TextStyle(
                                  fontSize: 14,
                                  fontFamily: "JakartaMedium",
                                ),
                              ),
                              trailing: SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            );
                          }),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
