import 'dart:async';
import 'dart:convert';
import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:generp/Models/ordersModels/addOrderAccontDetailsResponse.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:geolocator/geolocator.dart';
import 'package:geolocator/geolocator.dart' as geo_location;
import 'package:google_maps_flutter/google_maps_flutter.dart';
import 'package:image_picker/image_picker.dart';
import 'package:intl/intl.dart';
import 'package:location/location.dart' as Location;
import 'package:provider/provider.dart';

import '../../Models/commonModels/DistrictsResponse.dart';
import '../../Models/commonModels/SubLocationsResponse.dart';
import '../../Models/ordersModels/AddOrderPaymentSelectAccountResponse.dart';
import '../../Models/ordersModels/AddOrderViewResponse.dart';
import '../../Models/ordersModels/addOrderTpcAgentListResponse.dart';
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class Addorderprovider extends ChangeNotifier {
  TextEditingController dropDownSearchController = TextEditingController();
  TextEditingController dropDownTpcSearchController = TextEditingController();
  TextEditingController billingStateSearchController = TextEditingController();
  TextEditingController billingDistrictSearchController =
      TextEditingController();
  TextEditingController billingSubLocSearchController = TextEditingController();
  TextEditingController dispatchStateSearchController = TextEditingController();
  TextEditingController dispatchDistrictSearchController =
      TextEditingController();
  TextEditingController dispatchSubLocSearchController =
      TextEditingController();

  TextEditingController billingNameController = TextEditingController();
  TextEditingController billingAddressController = TextEditingController();
  TextEditingController billingPincodeController = TextEditingController();
  TextEditingController dispatchAddressController = TextEditingController();
  TextEditingController dispatchPincodeController = TextEditingController();
  TextEditingController gstController = TextEditingController();
  TextEditingController orderReceivedDateController = TextEditingController();
  TextEditingController tpcAmountController = TextEditingController();

  List<TextEditingController> ProductControllers = [];
  List<TextEditingController> PriceControllers = [];
  List<TextEditingController> QuantityControllers = [];
  List<TextEditingController> CGSTControllers = [];
  List<TextEditingController> SGSTControllers = [];
  List<TextEditingController> IGSTControllers = [];
  List<TextEditingController> TotalPriceControllers = [];
  List<TextEditingController> TaxableValueControllers = [];

  TextEditingController ProductController = TextEditingController();
  TextEditingController PriceController = TextEditingController();
  TextEditingController QuantityController = TextEditingController(text: "1");
  TextEditingController CGSTController = TextEditingController(text: "9");
  TextEditingController SGSTController = TextEditingController(text: "9");
  TextEditingController IGSTController = TextEditingController(text: "0");
  TextEditingController TotalPriceController = TextEditingController();
  TextEditingController TaxableValueController = TextEditingController();
  List<Map<String, dynamic>> _productRows = []; // For backend
  List<Map<String, dynamic>> get productRows => _productRows;

  TextEditingController basicAmountReadOnlyController = TextEditingController();
  TextEditingController cgstReadOnlyController = TextEditingController();
  TextEditingController sgstReadOnlyController = TextEditingController();
  TextEditingController igstReadOnlyController = TextEditingController();
  TextEditingController totalReadOnlyAmountController = TextEditingController();
  TextEditingController noteController = TextEditingController();
  List<AccountList> _accountList = [];
  List<Employees> _employees = [];
  List<States> _billingStates = [];
  List<States> _dispatchStates = [];
  List<SaleProducts> _saleProducts = [];

  List<Districts> _billingDistricts = [];
  List<Districts> _dispatchDistricts = [];
  List<SubLocations> _billingSubLocations = [];
  List<SubLocations> _dispatchSubLocations = [];

  List<String> _unloadingScope = [];
  List<String> _freightScope = [];
  List<String> _erectionScope = [];
  List<String> _tpcApplicable = [];
  List<TpcList> _tpcAgent = [];



  String? selectAccountError;
  String? orderDateError;
  String? billingNameError;
  String? billingAddressError;
  String? billingPincodeError;
  String? dispatchAddressError;
  String? dispatchPincodeError;
  String? tpcAmountError;
  String? gstError;
  String? selectedBillingStateError;
  String? selectedBillingDistrictError;
  String? selectedBillingSubLocError;
  String? selectedDispatchStateError;
  String? selectedDispatchDistrictError;
  String? selectedDispatchSubLocError;
  String? selectedTPCApplicableError;
  String? selectedUnloadingScopeError;
  String? selectedFreightScopeError;
  String? selectedErectionScopeError;
  String? selectedTPCAgentError;

  AccountList? _selectedAccountList;
  String? _selectedAccountID;
  String? _selectedAccountName;

  Employees? _selectedEmployees;
  String? _selectedEmployeeID;
  String? _selectedEmployeeName;

  States? _selectedBillingStates;
  String? _selectedBillingStateID;
  String? _selectedBillingStateName;

  Districts? _selectedBillingDistricts;
  String? _selectedBillingDistrictID;
  String? _selectedBillingDistrictValue;

  SubLocations? _selectedBillingSubLocations;
  String? _selectedBillingSubLocID;
  String? _selectedBillingSubLocValue;

  States? _selectedDispatchStates;
  String? _selectedDispatchStateID;
  String? _selectedDispatchStateName;

  Districts? _selectedDispatchDistricts;
  String? _selectedDispatchDistrictID;
  String? _selectedDispatchDistrictValue;

  SubLocations? _selectedDispatchSubLocations;
  String? _selectedDispatchSubLocID;
  String? _selectedDispatchSubLocValue;

  SaleProducts? _selectedSaleProducts;

  List<String?> _selectedSaleProductID = [];
  String? _selectedSaleProductName;
  String? _selectedSingleSaleProductID;

  String? _selectedUnloadingScope;
  String? _selectedFreightScope;
  String? _selectedErectionScope;
  String? _selectedTpcStatus;
  TpcList? _selectedTpcAgent;
  String? _selectedTpcAgentID;
  String? _selectedTpcAgentValue;

  LatLng startLocation = const LatLng(17.439112226708446, 78.43292499146135);
  LatLng? currentLocationLatLng;
  String latlongs = "";
  Set<Marker> markers = {};
  Location.LocationData? currentLocation;
  bool isLocationEnabled = false;
  bool hasLocationPermission = false;

  String? FileError;
  bool _isLoading = false;
  int _imagePicked = 0;
  File? _image;
  File? _imageName;
  final ImagePicker _picker = ImagePicker();
  DateTime? _date;
  String? _formattedDate;
  Timer? _debounce;
  List<Map<String, String>> _selectedOrders = [];
  String? productsEmptyError;
  List<Map<String, String>> get selectedOrders => _selectedOrders;

  bool _submitClicked = false;

  bool get submitClicked => _submitClicked;

  set submitClicked(bool value) {
    _submitClicked = value;
    notifyListeners();
  }

  set selectedOrders(value) {
    _selectedOrders = selectedOrders;
    notifyListeners();
  }

  set productRows(value) {
    _productRows = value;
    productsEmptyError = "";
    notifyListeners();
  }

  bool get isLoading => _isLoading;

  String? get formattedDate => _formattedDate;

  DateTime? get dateNow => _date;

  File? get imagePath => _imageName;

  File? get imageFilePath => _image;

  int get imagePicked => _imagePicked;

  List<AccountList> get accountList => _accountList;

  List<Employees> get employees => _employees;

  List<SaleProducts> get saleProducts => _saleProducts;

  List<String> get unloadingScope => _unloadingScope;

  List<String> get freightScope => _freightScope;

  List<String> get erectionScope => _erectionScope;

  List<String> get tpcApplicable => _tpcApplicable;

  List<TpcList> get tpcAgent => _tpcAgent;

  AccountList? get selectedAccountList => _selectedAccountList;

  String? get selectedAccountID => _selectedAccountID;

  String? get selectedAccountName => _selectedAccountName;

  Employees? get selectedEmployees => _selectedEmployees;

  String? get selectedEmployeeID => _selectedEmployeeID;

  String? get selectedEmployeeName => _selectedEmployeeName;

  List<States> get billingStates => _billingStates;

  States? get selecetdBillingStates => _selectedBillingStates;

  String? get selectedBillingStateID => _selectedBillingStateID;

  String? get selectedBillingStateName => _selectedBillingStateName;

  List<Districts> get billingDistricts => _billingDistricts;

  List<SubLocations> get billingSubLocations => _billingSubLocations;

  Districts? get selectedBillingDistricts => _selectedBillingDistricts;

  String? get selectedBillingDistrictId => _selectedBillingDistrictID;

  String? get selectedBillingDistrictValue => _selectedBillingDistrictValue;

  SubLocations? get selectedBillingSubLocations => _selectedBillingSubLocations;

  String? get selectedBillingSubLocID => _selectedBillingSubLocID;

  String? get selectedBillingSubLocValue => _selectedBillingSubLocValue;

  List<States> get dispatchStates => _dispatchStates;

  States? get selecetdDispatchStates => _selectedDispatchStates;

  String? get selectedDispatchStateID => _selectedDispatchStateID;

  String? get selectedDispatchStateName => _selectedDispatchStateName;

  List<Districts> get dispatchDistricts => _dispatchDistricts;

  List<SubLocations> get dispatchSubLocations => _dispatchSubLocations;

  Districts? get selectedDispatchDistricts => _selectedDispatchDistricts;

  String? get selectedDispatchDistrictId => _selectedDispatchDistrictID;

  String? get selectedDispatchDistrictValue => _selectedDispatchDistrictValue;

  SubLocations? get selectedDispatchSubLocations =>
      _selectedDispatchSubLocations;

  String? get selectedDispatchSubLocID => _selectedDispatchSubLocID;

  String? get selectedDispatchSubLocValue => _selectedDispatchSubLocValue;

  SaleProducts? get selectedSaleProducts => _selectedSaleProducts;

  List<String?> get selectedSaleProductID => _selectedSaleProductID;

  String? get selectedSaleProductName => _selectedSaleProductName;
  String? get selectedSingleSaleProductID => _selectedSingleSaleProductID;

  String? get selectedUnloadingScope => _selectedUnloadingScope;

  String? get selectedFreightScope => _selectedFreightScope;

  String? get selectedErectionScope => _selectedErectionScope;

  String? get selectedTpcStatus => _selectedTpcStatus;

  TpcList? get selectedTpcAgent => _selectedTpcAgent;

  String? get selectedTpcAgentID => _selectedTpcAgentID;

  String? get selectedTpcAgentValue => _selectedTpcAgentValue;


  set accountList(List<AccountList> value) {
    _accountList = value;
    notifyListeners();
  }

  set selectedAccountList(AccountList? value) {
    _selectedAccountList = value;
    _selectedAccountID = value!.id;
    _selectedAccountName = value.text!;
    notifyListeners();
  }

  set selectedAccountID(String? value) {
    _selectedAccountID = value;
    notifyListeners();
  }

  set selectedAccountName(String? value) {
    _selectedAccountName = value;
    notifyListeners();
  }

  set selectedEmployees(Employees? value) {
    _selectedEmployees = value;
    _selectedEmployeeID = value!.id;
    _selectedEmployeeName = value.name!;
    notifyListeners();
  }

  set selectedEmployeeID(String? value) {
    _selectedEmployeeID = value;
    notifyListeners();
  }

  set selectedEmployeeName(String? value) {
    _selectedEmployeeName = value;
    notifyListeners();
  }

  set selecetdBillingStates(States? value) {
    _selectedBillingStates = value;
    _selectedBillingStateID = value!.id;
    _selectedBillingStateName = value.name!;
    selectedBillingStateError = "";
    notifyListeners();
  }

  set selectedBillingStateID(String? value) {
    _selectedBillingStateID = value;
    selectedBillingStateError = "";
    notifyListeners();
  }

  set selectedBillingStateName(String? value) {
    _selectedBillingStateName = value;
    selectedBillingStateError = "";
    notifyListeners();
  }

  set selectedBillingDistricts(Districts? value) {
    _selectedBillingDistricts = value;
    _selectedBillingDistrictID = value!.id;
    _selectedBillingDistrictValue = value.district;
    selectedBillingDistrictError = "";
    // districtError = null;
    notifyListeners();
  }

  set selectedBillingSubLocations(SubLocations? value) {
    _selectedBillingSubLocations = value;
    _selectedBillingSubLocID = value!.id;
    _selectedBillingSubLocValue = value.subLocality!;
    selectedBillingSubLocError = "";
    // localityError = null;
    notifyListeners();
  }

  set selectedBillingDistrictId(value) {
    _selectedBillingDistrictID = value;
    notifyListeners();
  }

  set selectedBillingDistrictValue(value) {
    _selectedBillingDistrictValue = value;
    notifyListeners();
  }

  set selectedBillingSubLocID(value) {
    _selectedBillingSubLocID = value;
    notifyListeners();
  }

  set selectedBillingSubLocValue(value) {
    _selectedBillingSubLocValue = value;
    notifyListeners();
  }

  set selecetdDispatchStates(States? value) {
    _selectedDispatchStates = value;
    _selectedDispatchStateID = value?.id;
    _selectedDispatchStateName = value!.name!;
    selectedDispatchStateError = null;
    notifyListeners();
  }

  set selectedDispatchStateID(String? value) {
    _selectedDispatchStateID = value;
    notifyListeners();
  }

  set selectedDispatchStateName(String? value) {
    _selectedDispatchStateName = value;
    notifyListeners();
  }

  set selectedDispatchDistricts(Districts? value) {
    _selectedDispatchDistricts = value;
    _selectedDispatchDistrictID = value?.id;
    _selectedDispatchDistrictValue = value!.district;
    selectedDispatchDistrictError = null;
    // districtError = null;
    notifyListeners();
  }

  set selectedDispatchSubLocations(SubLocations? value) {
    _selectedDispatchSubLocations = value;
    _selectedDispatchSubLocID = value?.id;
    _selectedDispatchSubLocValue = value!.subLocality!;
    selectedDispatchSubLocError = null;
    // localityError = null;
    notifyListeners();
  }

  set selectedDispatchDistrictId(value) {
    _selectedDispatchDistrictID = value;
    notifyListeners();
  }

  set selectedDispatchDistrictValue(value) {
    _selectedDispatchDistrictValue = value;
    notifyListeners();
  }

  set selectedDispatchSubLocID(value) {
    _selectedDispatchSubLocID = value;
    notifyListeners();
  }

  set selectedDispatchSubLocValue(value) {
    _selectedDispatchSubLocValue = value;
    notifyListeners();
  }

  set selectedSaleProducts(SaleProducts? value) {
    _selectedSaleProducts = value;
    _selectedSingleSaleProductID = value!.id!;
    // _selectedSaleProductID = value!.id!;
    // _selectedSaleProductName = value!.prodName;
    notifyListeners();
  }

  set selectedSaleProductID(List<String?> value) {
    _selectedSaleProductID = value;
    notifyListeners();
  }

  set selectedSingleSaleProductID(String? value) {
    _selectedSingleSaleProductID = value;
    notifyListeners();
  }

  set selectedSaleProductName(String? value) {
    _selectedSaleProductName = value;
    notifyListeners();
  }

  set selectedUnloadingScope(String? value) {
    _selectedUnloadingScope = value;
    selectedUnloadingScopeError = null;
    notifyListeners();
  }

  set selectedFreightScope(String? value) {
    _selectedFreightScope = value;
    selectedFreightScopeError = null;
    notifyListeners();
  }

  set selectedErectionScope(String? value) {
    _selectedErectionScope = value;
    selectedErectionScopeError = null;
    notifyListeners();
  }

  set selectedTpcStatus(String? value) {
    _selectedTpcStatus = value;
    selectedTPCApplicableError = null;
    notifyListeners();
  }

  set selectedTpcAgent(TpcList? value) {
    _selectedTpcAgent = value;
    _selectedTpcAgentID = value!.id;
    _selectedTpcAgentValue = value.text;
    selectedTPCAgentError = null;
    notifyListeners();
  }

  set selectedTpcAgentID(String? value) {
    _selectedTpcAgentID = value;
    notifyListeners();
  }

  set selectedTpcAgentValue(String? value) {
    _selectedTpcAgentValue = value;
    notifyListeners();
  }



  set imagePath(File? value) {
    _imageName = value;
    FileError = null;
    notifyListeners();
  }

  set imageFilePath(File? value) {
    _image = value;
    notifyListeners();
  }

  set imagePicked(value) {
    _imagePicked = value;
    notifyListeners();
  }

  set formattedDate(String? value) {
    _formattedDate = value;
    orderReceivedDateController.text = _formattedDate!;
    orderDateError = null;
    notifyListeners();
  }

  void setDate(DateTime newDate) {
    _date = newDate;
    _formattedDate = DateFormat('yyyy-MM-dd').format(newDate);
    orderReceivedDateController.text = _formattedDate!;
    orderDateError = null;
    notifyListeners();
  }

  // dynamic get basicAmount {
  //   double total = 0;
  //   total += double.tryParse(TaxableValueController.text)?.round() ?? 0.0;
  //   basicAmountReadOnlyController.text = total.toStringAsFixed(2);
  //   return total;
  // }
  //
  // dynamic get cgstAmount {
  //   double total = 0;
  //
  //     final taxableValue =
  //         double.tryParse(TaxableValueController.text) ?? 0.0;
  //     final cgst = double.tryParse(CGSTController.text) ?? 0.0;
  //     total += (taxableValue * cgst) / 100;
  //
  //   cgstReadOnlyController.text = total.toStringAsFixed(2);
  //   return total;
  // }
  //
  // dynamic get sgstAmount {
  //   double total = 0;
  //
  //     final taxableValue =
  //         double.tryParse(TaxableValueController.text) ?? 0.0;
  //     final sgst = double.tryParse(SGSTController.text) ?? 0.0;
  //     total += (taxableValue * sgst).round() / 100;
  //
  //   sgstReadOnlyController.text = total.toStringAsFixed(2);
  //   return total;
  // }
  //
  // dynamic get igstAmount {
  //   double total = 0;
  //
  //     final taxableValue =
  //         double.tryParse(TaxableValueController.text) ?? 0.0;
  //     final igst = double.tryParse(IGSTController.text) ?? 0.0;
  //     total += (taxableValue * igst).round() / 100;
  //
  //   igstReadOnlyController.text = total.toStringAsFixed(2);
  //   return total;
  // }
  //
  // dynamic get totalAmount {
  //   double total = basicAmount + cgstAmount + sgstAmount + igstAmount;
  //   totalReadOnlyAmountController.text = total.round().toStringAsFixed(2);
  //   return total!;
  // }

  void addProduct(Map<String, dynamic> product) {
    productRows.add(product);
    updateSummaryCalculations();
    notifyListeners();
  }

  void updateProduct(int index, Map<String, dynamic> updatedProduct) {
    productRows[index] = updatedProduct;
    updateSummaryCalculations();
    notifyListeners();
  }

  void updateProductCalculations() {
    final inclusivePrice = double.tryParse(PriceController.text) ?? 0.0;
    final quantity = double.tryParse(QuantityController.text) ?? 1.0;
    final cgst = double.tryParse(CGSTController.text) ?? 0.0;
    final sgst = double.tryParse(SGSTController.text) ?? 0.0;
    final igst = double.tryParse(IGSTController.text) ?? 0.0;
    final totalTaxRate = (cgst + sgst + igst) / 100;
    // Calculate taxable value per unit
    final taxableValuePerUnit = inclusivePrice / (1 + totalTaxRate);
    // Total taxable value = taxable value per unit * quantity
    final totalTaxableValue = taxableValuePerUnit * quantity;
    TaxableValueController.text = totalTaxableValue.toStringAsFixed(0);
    notifyListeners();
  }

  void updateSummaryCalculations() {
    double basicAmount = 0.0;
    double cgstAmount = 0.0;
    double sgstAmount = 0.0;
    double igstAmount = 0.0;

    for (var product in productRows) {
      final price = double.tryParse(product['price']?.toString() ?? '0') ?? 0.0;
      final qty = double.tryParse(product['qty']?.toString() ?? '0') ?? 0.0;
      final cgst = double.tryParse(product['cgst_p']?.toString() ?? '0') ?? 0.0;
      final sgst = double.tryParse(product['sgst_p']?.toString() ?? '0') ?? 0.0;
      final igst = double.tryParse(product['igst_p']?.toString() ?? '0') ?? 0.0;

      final taxableValue = price * qty;
      basicAmount += taxableValue;
      cgstAmount += (taxableValue * cgst) / 100;
      sgstAmount += (taxableValue * sgst) / 100;
      igstAmount += (taxableValue * igst) / 100;
    }

    final totalAmount = basicAmount + cgstAmount + sgstAmount + igstAmount;

    basicAmountReadOnlyController.text = basicAmount.toStringAsFixed(2);
    cgstReadOnlyController.text = cgstAmount.toStringAsFixed(2);
    sgstReadOnlyController.text = sgstAmount.toStringAsFixed(2);
    igstReadOnlyController.text = igstAmount.toStringAsFixed(2);
    totalReadOnlyAmountController.text = totalAmount.toStringAsFixed(2);

    notifyListeners();
  }

  String getJsonEncodedProducts() {
    return jsonEncode(productRows);
  }

  dynamic get basicAmount {
    return double.tryParse(basicAmountReadOnlyController.text) ?? 0.0;
  }

  dynamic get cgstAmount {
    return double.tryParse(cgstReadOnlyController.text) ?? 0.0;
  }

  dynamic get sgstAmount {
    return double.tryParse(sgstReadOnlyController.text) ?? 0.0;
  }

  dynamic get igstAmount {
    return double.tryParse(igstReadOnlyController.text) ?? 0.0;
  }

  dynamic get totalAmount {
    return double.tryParse(totalReadOnlyAmountController.text) ?? 0.0;
  }

  void updateSelectedSingleProduct(SaleProducts? product) {
    _selectedSaleProducts = product;
    _selectedSingleSaleProductID = product!.id;
    PriceController.text = product.price!;
    updateProductCalculations();
    notifyListeners();
  }

  void prefillProductForEdit(int index) {
    final product = productRows[index];
    selectedSaleProducts = saleProducts.firstWhere(
      (p) => p.id == product['product_id'],
      orElse: () => SaleProducts(id: '', prodName: 'Unknown'),
    );
    selectedSingleSaleProductID = product['product_id'];
    selectedSaleProductName = selectedSaleProducts?.prodName;
    QuantityController.text = product['qty'] ?? '';
    PriceController.text = product['price'] ?? '';
    CGSTController.text = product['cgst_p'] ?? '';
    SGSTController.text = product['sgst_p'] ?? '';
    IGSTController.text = product['igst_p'] ?? '';
    TaxableValueController.text = product['total_price'] ?? '';
    notifyListeners();
  }

  // void addNewRow() {
  //   ProductControllers.add(TextEditingController());
  //   PriceControllers.add(TextEditingController());
  //   QuantityControllers.add(TextEditingController(text: '1'));
  //   CGSTControllers.add(TextEditingController(text: '9'));
  //   SGSTControllers.add(TextEditingController(text: '9'));
  //   IGSTControllers.add(TextEditingController(text: '0'));
  //   TaxableValueControllers.add(TextEditingController());
  //   TotalPriceControllers.add(TextEditingController());
  //
  //   selectedSaleProductID.add(null);
  //   notifyListeners();
  // }
  //
  // void removeRow(int index) {
  //   if (index >= 0 && index < ProductControllers.length) {
  //     ProductControllers[index].dispose();
  //     PriceControllers[index].dispose();
  //     QuantityControllers[index].dispose();
  //     CGSTControllers[index].dispose();
  //     SGSTControllers[index].dispose();
  //     IGSTControllers[index].dispose();
  //     TaxableValueControllers[index].dispose();
  //     TotalPriceControllers[index].dispose();
  //     ProductControllers.removeAt(index);
  //     PriceControllers.removeAt(index);
  //     QuantityControllers.removeAt(index);
  //     CGSTControllers.removeAt(index);
  //     SGSTControllers.removeAt(index);
  //     IGSTControllers.removeAt(index);
  //     TaxableValueControllers.removeAt(index);
  //     TotalPriceControllers.removeAt(index);
  //     selectedSaleProductID.removeAt(index);
  //     notifyListeners();
  //   }
  // }
  //
  // void updateSelectedProduct(int index, SaleProducts? product) {
  //   if (index >= 0 && index < _saleProducts.length) {
  //     _selectedSaleProducts = product;
  //     _selectedSaleProductID[index] = product!.id;
  //     PriceControllers[index].text = product!.price!;
  //     updateRowCalculations(index);
  //     notifyListeners();
  //   }
  // }
  //
  // void updateRowCalculations(int index) {
  //   if (index >= 0 && index < PriceControllers.length) {
  //     final inclusivePrice =
  //         double.tryParse(PriceControllers[index].text) ?? 0.0;
  //     final quantity = double.tryParse(QuantityControllers[index].text) ?? 1.0;
  //     final cgst = double.tryParse(CGSTControllers[index].text) ?? 0.0;
  //     final sgst = double.tryParse(SGSTControllers[index].text) ?? 0.0;
  //     final igst = double.tryParse(IGSTControllers[index].text) ?? 0.0;
  //     final totalTaxRate = (cgst + sgst + igst) / 100;
  //     // Calculate taxable value per unit
  //     final taxableValuePerUnit = inclusivePrice / (1 + totalTaxRate);
  //     // Total taxable value = taxable value per unit * quantity
  //     final totalTaxableValue = taxableValuePerUnit * quantity;
  //     TaxableValueControllers[index].text = totalTaxableValue.toStringAsFixed(
  //       0,
  //     );
  //     notifyListeners();
  //   }
  // }
  //
  // Map<String, dynamic> getFormData() {
  //   final List<Map<String, dynamic>> orders = [];
  //   for (int i = 0; i < ProductControllers.length; i++) {
  //     orders.add({
  //       'product_id': selectedSaleProductID[i],
  //       'qty': QuantityControllers[i].text,
  //       'price': PriceControllers[i].text,
  //       'cgst_p': CGSTControllers[i].text,
  //       'sgst_p': SGSTControllers[i].text,
  //       'igst_p': IGSTControllers[i].text,
  //       'total_price': TaxableValueControllers[i].text,
  //     });
  //   }
  //   return {
  //     'orders': orders,
  //     'basic_amount': basicAmount.toStringAsFixed(2),
  //     'cgst_amount': cgstAmount.toStringAsFixed(2),
  //     'sgst_amount': sgstAmount.toStringAsFixed(2),
  //     'igst_amount': igstAmount.toStringAsFixed(2),
  //     'total_amount': totalAmount.toStringAsFixed(2),
  //     'note': noteController.text,
  //   };
  // }

  Future<void> ordersAddOrderAPIViewFunction(context, mode, leadId, feedback, followupType, inTime, loc) async {
    try {
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.addOrderViewAPI(
          provider.empId,
          provider.session,
          mode,
          leadId,
          feedback,
          followupType,
          inTime,
          loc
      );
      if (data != null) {
        if (data.error == "0") {
          _tpcApplicable = ["Yes", "No"];
          _erectionScope = data.erectionScope ?? [];
          _unloadingScope = data.unloadingScope ?? [];
          _freightScope = data.freightScope ?? [];
          _employees = data.employees ?? [];
          _billingStates = data.states ?? [];
          _dispatchStates = data.states ?? [];
          _saleProducts = data.saleProducts ?? [];

          checkDropdownselected();

          notifyListeners();
        } else {}
      } else {}
    } catch (e) {}
  }


  // AccountDetails _accountDetails = AccountDetails();
  //
  // AccountDetails get accountDetails => _accountDetails;

  AccountDetails? _accountDetails; // nullable
  AccountDetails? get accountDetails => _accountDetails;
  set accountDetails(AccountDetails? value) {
    _accountDetails = value;
    notifyListeners();
  }


  Future<void> fetchAddOrderViewData(
      BuildContext context,
      String empId,
      String session,
      String mode,
      leadId,
      feedback,
      followupType,
      inTime,
      loc
      ) async {
    debugPrint("🔥 fetchAddOrderViewData CALLED with leadId=$leadId, mode=$mode");
    try {
      _isLoading = true;
      notifyListeners();

      final response = await ApiCalling.addOrderViewAPI(
          empId, session, mode, leadId, feedback, followupType, inTime, loc
      );
      if (response != null) {
        if (response.error == "0") {
          _tpcApplicable = ["Yes", "No"];
          _erectionScope = response.erectionScope ?? [];
          _unloadingScope = response.unloadingScope ?? [];
          _freightScope = response.freightScope ?? [];
          _employees = response.employees ?? [];
          _billingStates = response.states ?? [];
          _dispatchStates = response.states ?? [];
          _saleProducts = response.saleProducts ?? [];
          // getSubLocationAPI(context, response.accountDetails?.subLocality);
          // getDistrictAPI(context, response.accountDetails?.district);
          // _billingStates = response.accountDetails?.state as List<States>;

          checkDropdownselected();

          notifyListeners();
        } else {}
      } else {}

      debugPrint(" data to all fields##################################");
      if (response != null) {
        debugPrint("Employees: ${response.accountDetails?.pincode}");
        debugPrint("States: ${response.accountDetails?.state}");
        debugPrint("Sale Products: ${response.accountDetails?.address}");
        debugPrint("Account Details Name: ${response.accountDetails?.name}");
        debugPrint("District: ${response.accountDetails?.district}");
        debugPrint("Sub location: ${response.accountDetails?.name}");


      } else {
        debugPrint("Response is NULL");
      }

      if (response != null && response.error == "0") {
        // Save accountDetails safely
        _accountDetails = AccountDetails(
          id: response.accountDetails?.id,
          name: response.accountDetails?.name,
          address: response.accountDetails?.address,
          state: response.accountDetails?.state,
          pincode: response.accountDetails?.pincode,
          date: response.accountDetails?.date,
          subLocality: response.accountDetails?.subLocality,
          district: response.accountDetails?.district,
        );


        // Save lists safely
        _unloadingScope = response.unloadingScope ?? [];
        _freightScope = response.freightScope ?? [];
        _erectionScope = response.erectionScope ?? [];

        // default selections
        if (_employees.isNotEmpty) selectedEmployees = _employees.first;
        if (leadId != "")
        if (_billingStates.isNotEmpty) selecetdBillingStates = _billingStates.first;
        if (_billingDistricts.isNotEmpty) selectedBillingDistricts = _billingDistricts.first;
        if (_billingStates.isNotEmpty) selecetdBillingStates = _billingStates.first;
        if (_dispatchStates.isNotEmpty) selecetdDispatchStates = _dispatchStates.first;
        if (_saleProducts.isNotEmpty) selectedSaleProducts = _saleProducts.first;
        if (_unloadingScope.isNotEmpty) selectedUnloadingScope = _unloadingScope.first;
        if (_freightScope.isNotEmpty) selectedFreightScope = _freightScope.first;
        if (_erectionScope.isNotEmpty) selectedErectionScope = _erectionScope.first;

        notifyListeners(); // notify listeners/UI
      } else {
        debugPrint("API Error: ${response?.message}");
      }
    } catch (e) {
      debugPrint("Provider Error in fetchAddOrderViewData: $e");
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }


  void checkDropdownselected() {
    if (_selectedAccountList != null &&
        !_accountList.contains(_selectedAccountList)) {
      _selectedAccountID = null;
      _selectedAccountName = "";
    }
    if (_selectedEmployees != null &&
        !_employees.contains(_selectedEmployees)) {
      _selectedEmployeeID = null;
      _selectedEmployeeName = "";
    }
    if (_selectedBillingStates != null &&
        !_billingStates.contains(_selectedBillingStates)) {
      _selectedBillingStateID = null;
      _selectedBillingStateName = "";
    }
    if (_selectedBillingDistricts != null &&
        !_billingDistricts.contains(_selectedBillingDistricts)) {
      _selectedBillingDistrictID = null;
      _selectedBillingDistrictValue = "";
    }
    if (_selectedBillingSubLocations != null &&
        !_billingSubLocations.contains(_selectedBillingSubLocations)) {
      _selectedBillingSubLocID = null;
      _selectedBillingSubLocValue = "";
    }
    if (_selectedDispatchStates != null &&
        !_dispatchStates.contains(_selectedDispatchStates)) {
      _selectedDispatchStateID = null;
      _selectedDispatchStateName = "";
    }
    if (_selectedDispatchDistricts != null &&
        !_dispatchDistricts.contains(_selectedDispatchDistricts)) {
      _selectedDispatchDistrictID = null;
      _selectedDispatchDistrictValue = "";
    }
    if (_selectedDispatchSubLocations != null &&
        !_dispatchSubLocations.contains(_selectedDispatchSubLocations)) {
      _selectedDispatchSubLocID = null;
      _selectedDispatchSubLocValue = "";
    }
    if (_selectedUnloadingScope != null &&
        !_unloadingScope.contains(_selectedUnloadingScope)) {
      _selectedUnloadingScope = null;
    }
    if (_selectedFreightScope != null &&
        !_freightScope.contains(_selectedFreightScope)) {
      _selectedFreightScope = null;
    }
    if (_selectedErectionScope != null &&
        !_erectionScope.contains(_selectedErectionScope)) {
      _selectedErectionScope = null;
    }

    if (_selectedTpcStatus != null &&
        !_tpcApplicable.contains(_selectedTpcStatus)) {
      _selectedTpcStatus = null;
    }

    if (_selectedTpcAgent != null && !_tpcAgent.contains(_selectedTpcAgent)) {
      _selectedTpcAgentID = null;
      _selectedTpcAgentValue = "";
    }
    notifyListeners();
  }

  Future<void> ordersAddOrderAccountDetailsAPIFunction(
    context,
    accountId,
  ) async {
    try {
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.addOrderAccountDetailsAPI(
        provider.empId,
        provider.session,
        accountId,
      );
      if (data != null) {
        if (data.error == "0") {
          _accountDetails = data.accountDetails!;
          data.accountDetails!.accManagerId!;
          billingNameController.text = data.accountDetails!.name!;
          _selectedBillingStates = billingStates.firstWhere(
            (e) => e.id == data.accountDetails!.state!,
          );
          _selectedBillingStateID = data.accountDetails!.state!;
          _selectedBillingStateName =
              billingStates
                  .firstWhere((e) => e.id == data.accountDetails!.state!)
                  .name;

          _selectedBillingDistrictID = data.accountDetails!.district!;

          _selectedBillingSubLocID = data.accountDetails!.subLocality!;
          print("data.accountDetails!.state ${data.accountDetails!.state}");
          if (_selectedBillingStateID != null) {
            getDistrictAPI(context, data.accountDetails!.state);
          }
          if (_selectedBillingDistrictID != null) {
            getSubLocationAPI(context, data.accountDetails!.district);
          }

          billingPincodeController.text = data.accountDetails!.pincode!;
          billingAddressController.text = data.accountDetails!.address!;
          orderReceivedDateController.text = data.accountDetails!.date!;
          gstController.text = data.accountDetails!.gstNumber!;
          orderDateError = null;
          billingNameError = null;
          billingPincodeError = null;
          billingAddressError = null;
          selectedBillingStateError = null;
          selectedBillingDistrictError = null;
          selectedBillingSubLocError = null;
          notifyListeners();
        } else {}
      } else {}
    } catch (e) {}
  }

  Future<void> getDistrictAPI(context, stateID) async {
    try {
      var homeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      _billingDistricts.clear();
      notifyListeners();
      final data = await ApiCalling.commonAddAccountViewDistrictAPI(
        homeProv.empId,
        homeProv.session,
        stateID,
      );
      if (data != null) {
        if (data.error == "0") {
          _billingDistricts = data.districts!;
          _selectedBillingDistricts = data.districts!.firstWhere(
            (e) => e.id == accountDetails?.district!,
          );

          _selectedBillingDistrictValue =
              data.districts!
                  .firstWhere((e) => e.id == accountDetails?.district!)
                  .district;

          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> getDispatchDistrictAPI(context, stateID) async {
    try {
      var homeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      _dispatchDistricts.clear();
      notifyListeners();
      final data = await ApiCalling.commonAddAccountViewDistrictAPI(
        homeProv.empId,
        homeProv.session,
        stateID,
      );
      if (data != null) {
        if (data.error == "0") {
          _dispatchDistricts = data.districts!;

          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> getSubLocationAPI(context, districtID) async {
    try {
      var homeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      _billingSubLocations.clear();
      notifyListeners();
      final data = await ApiCalling.commonAddAccountViewSubLocationAPI(
        homeProv.empId,
        homeProv.session,
        districtID,
      );
      if (data != null) {
        if (data.error == "0") {
          _billingSubLocations = data.subLocations!;
          _selectedBillingSubLocations = data.subLocations!.firstWhere(
            (e) => e.id == accountDetails?.subLocality!,
          );

          _selectedBillingSubLocValue =
              data.subLocations!
                  .firstWhere((e) => e.id == accountDetails?.subLocality!)
                  .subLocality;

          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> getDispatchSubLocationAPI(context, districtID) async {
    try {
      var homeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      _dispatchSubLocations.clear();
      notifyListeners();
      final data = await ApiCalling.commonAddAccountViewSubLocationAPI(
        homeProv.empId,
        homeProv.session,
        districtID,
      );
      if (data != null) {
        if (data.error == "0") {
          _dispatchSubLocations = data.subLocations!;

          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> ordersAddOrderTPCAgentFunction(context, mode, text) async {
    try {
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.addOrderTPCAgentListAPI(
        provider.empId,
        provider.session,
        mode,
        text,
      );
      if (data != null) {
        if (data.error == "0") {
          _tpcAgent = data.tpcList!;
          notifyListeners();
        } else {}
      } else {}
    } catch (e) {}
  }

  Future<List<TpcList>> fetchTPCAccountsfromAPI(context, mode, text) async {
    try {
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.addOrderTPCAgentListAPI(
        provider.empId,
        provider.session,
        mode,
        text,
      );
      if (data != null) {
        if (data.error == "0") {
          _tpcAgent = data.tpcList!;
          notifyListeners();
          return _tpcAgent;
        } else {
          return [];
        }
      } else {
        return [];
      }
    } catch (e) {
      return [];
    }
  }

  Future<void> ordersAddOrderAPISubmitFunction(
    context,
    mode,
    selectedEmpid,
    selectedAcid,
    selectedDisStateid,
    selectedDisDistrictid,
    selectedDisSublocid,
    unloadingScope,
    frieghtScope,
    erectionScope,
    tpcStatus,
    selectedBilStateid,
    selectedBilDistrictid,
    selectedBilSublocid,
    tpcAgentId,
    orderProducts,
  ) async {
    try {
      if (!validateAddOrder()) {
        return;
      }
      _submitClicked = true;
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.addOrderSubmitAPI(
        provider.empId,
        provider.session,
        mode,
        selectedEmpid,
        selectedAcid,
        selectedDisStateid,
        selectedDisDistrictid,
        selectedDisSublocid,
        dispatchPincodeController.text,
        dispatchAddressController.text,
        basicAmount,
        cgstAmount,
        sgstAmount,
        igstAmount,
        totalAmount,
        formattedDate,
        noteController.text,
        unloadingScope,
        frieghtScope,
        erectionScope,
        tpcStatus,
        billingNameController.text,
        gstController.text,
        billingPincodeController.text,
        billingAddressController.text,
        selectedBilStateid,
        selectedBilDistrictid,
        selectedBilSublocid,
        orderProducts,
        "",
        "",
        "",
        latlongs,
        tpcAmountController.text,
        tpcAgentId,
        _image,
      );
      if (data != null) {
        if (data.error == "0") {
          _submitClicked = false;
          resetForm();
          Navigator.pop(context);
          toast(context, data.message);
          notifyListeners();
        } else {
          _submitClicked = false;
          notifyListeners();
        }
      } else {
        _submitClicked = false;
        notifyListeners();
      }
    } catch (e) {
      _submitClicked = false;
      notifyListeners();
    }
  }

  Future<void> getCurrentLocation() async {
    try {
      Position position = await Geolocator.getCurrentPosition(
        desiredAccuracy: geo_location.LocationAccuracy.high,
      );
      currentLocationLatLng = LatLng(position.latitude, position.longitude);
      latlongs = "${position.latitude}, ${position.longitude}";
      notifyListeners();
    } catch (e) {
      print("Error getting current location: $e");
    }
  }

  Future<void> getLocationPermission(BuildContext context) async {
    isLocationEnabled = await Geolocator.isLocationServiceEnabled();
    LocationPermission permission = await Geolocator.checkPermission();
    hasLocationPermission =
        permission == LocationPermission.always ||
        permission == LocationPermission.whileInUse;

    final Location.Location location = Location.Location();
    bool serviceEnabled = await location.serviceEnabled();
    if (!serviceEnabled) {
      serviceEnabled = await location.requestService();
      if (!serviceEnabled) {
        return;
      }
    }

    if (!isLocationEnabled || !hasLocationPermission) {
      permission = await Geolocator.requestPermission();
      if (permission != LocationPermission.always &&
          permission != LocationPermission.whileInUse) {
        showDialog(
          context: context,
          builder: (BuildContext context) {
            return AlertDialog(
              title: Text('Location Permission Required'),
              content: Text(
                'Please allow the app to access your location for core functionality.',
              ),
              actions: <Widget>[
                TextButton(
                  style: ButtonStyle(
                    backgroundColor: WidgetStateProperty.all(Colors.white),
                    overlayColor: WidgetStateProperty.all(Colors.white),
                  ),
                  onPressed: () async {
                    // await openAppSettings();
                    // Navigator.of(context).pop();
                    // Navigator.pushReplacement(
                    //   context,
                    //   MaterialPageRoute(builder: (context) => Attendance()),
                    // );
                  },
                  child: Text('OK'),
                ),
              ],
            );
          },
        );
        return;
      }
    }

    final Location.LocationData locData = await location.getLocation();
    currentLocation = locData;
    currentLocationLatLng = LatLng(locData.latitude!, locData.longitude!);
    latlongs = "${locData.latitude}, ${locData.longitude}";
    markers.clear();
    markers.add(
      Marker(
        markerId: MarkerId('current_location'),
        position: LatLng(locData.latitude!, locData.longitude!),
        infoWindow: InfoWindow(title: 'Current Location'),
        icon: BitmapDescriptor.defaultMarker,
      ),
    );
    latlongs = '${locData.latitude},${locData.longitude}';

    notifyListeners();
  }

  Future<void> ordersAddOrderSelectAccountAPIFunction(
    context,
    mode,
    accountId,
    search,
  ) async {
    print(search);
    try {
      if (search == null) {
        _accountList = [];
        _isLoading = false;
        notifyListeners();
        return;
      }
      _isLoading = true;
      notifyListeners();
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.AddOrderPaymentSelectAccountAPI(
        provider.empId,
        provider.session,
        mode,
        search,
      );
      if (data != null) {
        if (data.error == "0") {
          _accountList = data.accountList!;
          if (_selectedAccountList != null &&
              !_accountList.contains(_selectedAccountList)) {
            _selectedAccountList = null;
            _selectedAccountID = null;
            _selectedAccountName = null;
          }
          _isLoading = false;

          notifyListeners();
        } else {
          selectAccountError = data.message ?? "Failed to load accounts";
          _isLoading = false;
          notifyListeners();
        }
      } else {
        selectAccountError = "No data received from server";
        _isLoading = false;
        notifyListeners();
      }
    } catch (e) {
      selectAccountError = "An error occurred while fetching accounts";
      _isLoading = false;
      notifyListeners();
    }
  }

  Future<List<AccountList>> fetchAccountsFromApi(
    context,
    mode,
    accountId,
    search,
  ) async {
    print(search);
    try {
      if (search == null) {
        _accountList = [];
        _isLoading = false;
        notifyListeners();
        return _accountList;
      }
      _isLoading = true;
      notifyListeners();
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.AddOrderPaymentSelectAccountAPI(
        provider.empId,
        provider.session,
        mode,
        search,
      );
      if (data != null) {
        if (data.error == "0") {
          _accountList = data.accountList!;
          if (_selectedAccountList != null &&
              !_accountList.contains(_selectedAccountList)) {
            _selectedAccountList = null;
            _selectedAccountID = null;
            _selectedAccountName = null;
          }
          _isLoading = false;

          notifyListeners();
          return _accountList;
        } else {
          selectAccountError = data.message ?? "Failed to load accounts";
          _isLoading = false;

          notifyListeners();
          return [];
        }
      } else {
        selectAccountError = "No data received from server";
        _isLoading = false;
        notifyListeners();
        return [];
      }
    } catch (e) {
      selectAccountError = "An error occurred while fetching accounts";
      _isLoading = false;
      notifyListeners();
      return [];
    }
  }

  imgFromCamera(context) async {
    // Capture a photo
    try {
      final XFile? galleryImage = await _picker.pickImage(
        source: ImageSource.camera,
        imageQuality: 50,
      );
      debugPrint("added");

      _image = File(galleryImage!.path);
      _imageName = File(galleryImage.name);
      _imagePicked = 1;
      if (_imagePicked == 0) {
        FileError = "Please Select Attachment";
      }
      FileError = null;
      notifyListeners();
    } catch (e) {
      debugPrint("mmmm: ${e.toString()}");
    }
  }

  imgFromGallery(context) async {
    // Pick an image
    try {
      final XFile? galleryImage = await _picker.pickImage(
        source: ImageSource.gallery,
      );
      final bytes = (await galleryImage?.readAsBytes())?.lengthInBytes;
      final kb = bytes! / 1024;
      final mb = kb / 1024;

      debugPrint("Jenny: bytes:$bytes, kb:$kb, mb: $mb");

      _image = File(galleryImage!.path);
      _imageName = File(galleryImage.name);
      _imagePicked = 1;
      if (_imagePicked == 0) {
        FileError = "Please Select Attachment";
      }
      FileError = null;
      notifyListeners();
      // var file = FlutterImageCompress.compressWithFile(galleryImage!.path);
    } catch (e) {
      debugPrint("mmmm: ${e.toString()}");
    }
  }

  void onChangedBillingName(value) {
    billingNameError = null;
    notifyListeners();
  }

  void onChangeOrderDate(value) {
    orderDateError = null;
    notifyListeners();
  }

  void onChangedBillingAddress(value) {
    billingAddressError = null;
    notifyListeners();
  }

  void onChangedBillingPincode(value) {
    billingPincodeError = null;
    notifyListeners();
  }

  void onChangedDispatchAddress(value) {
    dispatchAddressError = null;
    notifyListeners();
  }

  void onChangedDispatchPincode(value) {
    dispatchPincodeError = null;
    notifyListeners();
  }

  void onChangedGst(value) {
    gstError = null;
    notifyListeners();
  }

  void onChangeTpcAmount(value) {
    tpcAmountError = null;
    notifyListeners();
  }

  bool validateAddOrder() {
    bool isValid = true;
    selectAccountError = null;
    billingNameError = null;
    orderDateError = null;
    billingAddressError = null;
    billingPincodeError = null;
    dispatchAddressError = null;
    dispatchPincodeError = null;
    gstError = null;
    tpcAmountError = null;
    selectedBillingStateError = null;
    selectedBillingDistrictError = null;
    selectedBillingSubLocError = null;
    selectedDispatchStateError = null;
    selectedDispatchDistrictError = null;
    selectedDispatchSubLocError = null;
    selectedUnloadingScopeError = null;
    selectedFreightScopeError = null;
    selectedErectionScopeError = null;
    selectedTPCApplicableError = null;
    selectedTPCAgentError = null;

    if (_selectedAccountList == null || _selectedAccountID == null) {
      selectAccountError = "Please select an Account";
      isValid = false;
    }

    if (_selectedAccountList == null || _selectedAccountID == null) {
      selectAccountError = "Please select an Account";
      isValid = false;
    }

    if (_selectedBillingStates == null || _selectedBillingStateID == null) {
      selectedBillingStateError = "Please select a State";
      isValid = false;
    }

    if (_selectedBillingDistricts == null ||
        _selectedBillingDistrictID == null) {
      selectedBillingDistrictError = "Please select a District";
      isValid = false;
    }

    if (_selectedBillingSubLocations == null ||
        _selectedBillingSubLocID == null) {
      selectedBillingSubLocError = "Please select a Location";
      isValid = false;
    }

    if (_selectedDispatchStates == null || _selectedDispatchStateID == null) {
      selectedDispatchStateError = "Please select a State";
      isValid = false;
    }

    if (_selectedDispatchDistricts == null ||
        _selectedDispatchDistrictID == null) {
      selectedDispatchDistrictError = "Please select a District";
      isValid = false;
    }

    if (_selectedDispatchSubLocations == null ||
        _selectedDispatchSubLocID == null) {
      selectedDispatchSubLocError = "Please select a Location";
      isValid = false;
    }

    if (orderReceivedDateController.text.trim().isEmpty) {
      orderDateError = "Please Enter Received Date";
      isValid = false;
    }
    if (billingNameController.text.trim().isEmpty) {
      isValid = false;
      billingNameError = "Please Enter Your Name";
    }
    if (billingAddressController.text.trim().isEmpty) {
      isValid = false;
      billingAddressError = "Please Enter Address";
    }
    if (billingPincodeController.text.trim().isEmpty) {
      isValid = false;
      billingPincodeError = "Please Enter Pin Code";
    }
    if (dispatchAddressController.text.trim().isEmpty) {
      dispatchAddressError = "Please Enter Dispatch Address";
      isValid = false;
    }
    if (dispatchPincodeController.text.trim().isEmpty) {
      dispatchPincodeError = "Please Enter Dispatch Pin Code";
      isValid = false;
    }
    if (gstController.text.trim().isEmpty) {
      gstError = "Please Enter GST Number";
      isValid = false;
    }
    if (_selectedUnloadingScope == null) {
      selectedUnloadingScopeError = "Please select a Scope";
      isValid = false;
    }
    if (_selectedFreightScope == null) {
      selectedFreightScopeError = "Please select a Scope";
      isValid = false;
    }
    if (_selectedErectionScope == null) {
      selectedErectionScopeError = "Please select a Scope";
      isValid = false;
    }
    if (_selectedTpcStatus == null) {
      selectedTPCApplicableError = "Please select TPC status";
      isValid = false;
    }
    if (_selectedTpcStatus == "Yes") {
      if (_selectedTpcAgent == null || _selectedTpcAgentID == null) {
        selectedTPCAgentError = "Please select an Agent";
        isValid = false;
      }
      if (tpcAmountController.text.trim().isEmpty) {
        isValid = false;
        tpcAmountError = "Please Enter Amount";
      }
    }
    _submitClicked = false;
    notifyListeners();
    return isValid;
  }

  bool validateForm1() {
    bool isValid = true;
    selectAccountError = null;
    billingNameError = null;
    orderDateError = null;
    billingAddressError = null;
    billingPincodeError = null;
    selectedBillingStateError = null;
    selectedBillingDistrictError = null;
    selectedBillingSubLocError = null;

    if (_selectedAccountList == null || _selectedAccountID == null) {
      selectAccountError = "Please select an Account";
      isValid = false;
    }

    if (_selectedBillingStates == null || _selectedBillingStateID == null) {
      selectedBillingStateError = "Please select a State";
      isValid = false;
    }

    if (_selectedBillingDistricts == null ||
        _selectedBillingDistrictID == null) {
      selectedBillingDistrictError = "Please select a District";
      isValid = false;
    }

    if (_selectedBillingSubLocations == null ||
        _selectedBillingSubLocID == null) {
      selectedBillingSubLocError = "Please select a Location";
      isValid = false;
    }

    if (orderReceivedDateController.text.trim().isEmpty) {
      isValid = false;
      orderDateError = "Please Enter Received Date";
    }
    if (billingNameController.text.trim().isEmpty) {
      isValid = false;
      billingNameError = "Please Enter Your Name";
    }
    if (billingAddressController.text.trim().isEmpty) {
      isValid = false;
      billingAddressError = "Please Enter Address";
    }
    if (billingPincodeController.text.trim().isEmpty) {
      isValid = false;
      billingPincodeError = "Please Enter Pin Code";
    }
    if (billingPincodeController.text.length < 6) {
      isValid = false;
      billingPincodeError = "Please Enter a valid Pin Code";
    }
    _submitClicked = false;
    notifyListeners();
    return isValid;
  }

  bool validateForm2() {
    bool isValid = true;
    dispatchAddressError = null;
    dispatchPincodeError = null;
    gstError = null;
    selectedDispatchStateError = null;
    selectedDispatchDistrictError = null;
    selectedDispatchSubLocError = null;
    FileError = null;

    if (_selectedDispatchStates == null || _selectedDispatchStateID == null) {
      selectedDispatchStateError = "Please select a State";
      isValid = false;
    }

    if (_selectedDispatchDistricts == null ||
        _selectedDispatchDistrictID == null) {
      selectedDispatchDistrictError = "Please select a District";
      isValid = false;
    }

    if (_selectedDispatchSubLocations == null ||
        _selectedDispatchSubLocID == null) {
      selectedDispatchSubLocError = "Please select a Location";
      isValid = false;
    }

    if (dispatchAddressController.text.trim().isEmpty) {
      dispatchAddressError = "Please Enter Dispatch Address";
      isValid = false;
    }
    if (dispatchPincodeController.text.trim().isEmpty) {
      dispatchPincodeError = "Please Enter Dispatch Pin Code";
      isValid = false;
    }
    if (dispatchPincodeController.text.length < 6) {
      isValid = false;
      dispatchPincodeError = "Please Enter a valid Pin Code";
    }
    if (gstController.text.trim().isEmpty) {
      gstError = "Please Enter GST Number";
      isValid = false;
    }
    if (_imagePicked == 0) {
      FileError = "Please provide an Attachment";
      isValid = false;
    }
    _submitClicked = false;
    notifyListeners();
    return isValid;
  }

  bool validateForm3() {
    bool isValid = true;

    tpcAmountError = null;
    selectedUnloadingScopeError = null;
    selectedFreightScopeError = null;
    selectedErectionScopeError = null;
    selectedTPCApplicableError = null;
    selectedTPCAgentError = null;

    if (_selectedUnloadingScope == null) {
      selectedUnloadingScopeError = "Please select a Scope";
      isValid = false;
    }
    if (_selectedFreightScope == null) {
      selectedFreightScopeError = "Please select a Scope";
      isValid = false;
    }
    if (_selectedErectionScope == null) {
      selectedErectionScopeError = "Please select a Scope";
      isValid = false;
    }
    if (_selectedTpcStatus == null) {
      selectedTPCApplicableError = "Please select TPC status";
      isValid = false;
    }

    if (_selectedTpcStatus == "Yes") {
      if (_selectedTpcAgent == null || _selectedTpcAgentID == null) {
        selectedTPCAgentError = "Please select an Agent";
        isValid = false;
      }
      if (tpcAmountController.text.trim().isEmpty) {
        tpcAmountError = "Please Enter Amount";
        isValid = false;
      }
    }
    _submitClicked = false;
    notifyListeners();
    return isValid;
  }

  bool validateForm4() {
    bool isValid = true;
    if (productRows.isEmpty || _productRows.isEmpty) {
      productsEmptyError = "Please Add min. one Product";
      isValid = false;
    }

    _submitClicked = false;
    notifyListeners();
    return isValid;
  }

  void resetForm() {
    _submitClicked = false;
    _productRows.clear();
    dropDownSearchController.clear();
    dropDownTpcSearchController.clear();
    billingNameController.clear();
    billingAddressController.clear();
    billingPincodeController.clear();
    dispatchAddressController.clear();
    dispatchPincodeController.clear();
    ProductController.clear();
    PriceController.clear();
    QuantityController.clear();
    CGSTController.clear();
    SGSTController.clear();
    IGSTController.clear();
    QuantityController.text = "1";
    CGSTController.text = "9";
    SGSTController.text = "9";
    IGSTController.text = "0";
    TotalPriceController.clear();
    TaxableValueController.clear();
    billingStateSearchController.clear();
    billingDistrictSearchController.clear();
    billingSubLocSearchController.clear();
    dispatchStateSearchController.clear();
    dispatchDistrictSearchController.clear();
    dispatchSubLocSearchController.clear();
    _productRows = [];
    gstController.clear();
    orderReceivedDateController.clear();
    tpcAmountController.clear();
    orderReceivedDateController.clear();
    noteController.clear();
    selectedSingleSaleProductID = null;
    for (var action in ProductControllers) {
      action.dispose();
    }
    ProductControllers.clear();
    for (var action in PriceControllers) {
      action.dispose();
    }
    PriceControllers.clear();
    for (var action in QuantityControllers) {
      action.dispose();
    }
    QuantityControllers.clear();
    for (var action in CGSTControllers) {
      action.dispose();
    }
    CGSTControllers.clear();
    for (var action in SGSTControllers) {
      action.dispose();
    }
    SGSTControllers.clear();
    for (var action in IGSTControllers) {
      action.dispose();
    }
    IGSTControllers.clear();
    for (var action in TotalPriceControllers) {
      action.dispose();
    }
    TotalPriceControllers.clear();
    for (var action in TaxableValueControllers) {
      action.dispose();
    }
    TaxableValueControllers.clear();
    basicAmountReadOnlyController.clear();
    cgstReadOnlyController.clear();
    sgstReadOnlyController.clear();
    igstReadOnlyController.clear();
    totalReadOnlyAmountController.clear();

    _image = null;
    _imageName = null;
    _imagePicked = 0;

    selectAccountError = null;
    orderDateError = null;
    billingNameError = null;
    billingAddressError = null;
    billingPincodeError = null;
    dispatchAddressError = null;
    dispatchPincodeError = null;
    selectedBillingStateError = null;
    selectedBillingDistrictError = null;
    selectedBillingSubLocError = null;
    selectedDispatchStateError = null;
    selectedDispatchDistrictError = null;
    selectedDispatchSubLocError = null;
    _selectedAccountList = null;
    _selectedEmployees = null;
    _selectedBillingStates = null;
    _selectedBillingDistricts = null;
    _selectedBillingSubLocations = null;
    _selectedDispatchStates = null;
    _selectedDispatchDistricts = null;
    _selectedDispatchSubLocations = null;
    _selectedSaleProducts = null;
    _selectedTpcAgent = null;
    _selectedUnloadingScope = null;
    _selectedFreightScope = null;
    _selectedErectionScope = null;
    _selectedTpcStatus = null;
    _selectedAccountID = "";
    _selectedAccountName = "";

    _selectedEmployeeID = "";
    _selectedEmployeeName = "";
    _selectedBillingStateID = "";
    _selectedBillingStateName = "";
    _selectedBillingDistrictID = "";
    _selectedBillingDistrictValue = "";
    _selectedBillingSubLocID = "";
    _selectedBillingSubLocValue = "";
    _selectedDispatchStateID = "";
    _selectedDispatchStateName = "";
    _selectedDispatchDistrictID = "";
    _selectedDispatchDistrictValue = "";
    _selectedDispatchSubLocID = "";
    _selectedDispatchSubLocValue = "";
    _selectedSaleProductID = [];
    _selectedSaleProductName = "";
    _selectedTpcStatus = "";
    _selectedTpcAgentID = "";
    _selectedTpcAgentValue = "";

    gstError = null;
    FileError = null;
    orderDateError = null;
    checkDropdownselected();
    notifyListeners();
  }

  void showDatePickerDialog(BuildContext context) {
    if (_date == null) {
      setDate(
        DateTime.now(),
      ); // Ensure current date is set before opening the picker
    }
    showCupertinoModalPopup<void>(
      context: context,
      builder:
          (BuildContext context) => Container(
            height: 250,
            padding: const EdgeInsets.only(top: 6.0),
            margin: EdgeInsets.only(
              bottom: MediaQuery.of(context).viewInsets.bottom,
            ),
            color: CupertinoColors.systemBackground.resolveFrom(context),
            child: SafeArea(
              top: false,
              child: Column(
                children: [
                  Expanded(
                    flex: 2,
                    child: SizedBox(
                      height: 40,
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          CupertinoButton(
                            child: Text(
                              'Cancel',
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                color: AppColors.app_blue,
                              ),
                            ),
                            onPressed: () {
                              Navigator.pop(context);
                            },
                          ),
                          CupertinoButton(
                            child: Text(
                              'Done',
                              style: TextStyle(
                                fontFamily: "JakartaMedium",
                                color: AppColors.app_blue,
                              ),
                            ),
                            onPressed: () {
                              setDate(_date ?? DateTime.now());

                              Navigator.pop(context);
                            },
                          ),
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 4,
                    child: CupertinoDatePicker(
                      dateOrder: DatePickerDateOrder.dmy,
                      initialDateTime: _date ?? DateTime.now(),
                      mode: CupertinoDatePickerMode.date,
                      use24hFormat: true,
                      showDayOfWeek: true,
                      onDateTimeChanged: (DateTime newDate) {
                        setDate(newDate);
                      },
                    ),
                  ),
                ],
              ),
            ),
          ),
    );
  }
}
