import 'package:flutter/material.dart';
import 'package:generp/Models/crmModels/appointmentCalendarResponse.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:provider/provider.dart';

import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class Appointmentcalendarprovider extends ChangeNotifier {
  bool _isLoading = false;
  List<Appointments> _appointmentsList = [];
  DateTime? _selectedDate;
  String? _selectedFollowUpType;

  bool get isLoading => _isLoading;
  String? get selectedFollowUpType => _selectedFollowUpType;
  List<Appointments> get appointmentList => _appointmentsList;
  DateTime? get selectedDate => _selectedDate;
  set selectedFollowUpType(String? value) {
    _selectedFollowUpType = value;
    notifyListeners();
  }

  set isLoading(bool value) {
    _isLoading = value;
    notifyListeners();
  }

  void setSelectedDate(DateTime date) {
    _selectedDate = date;
    notifyListeners();
  }

  Future<void> crmAppointmentCalendarAPIFunction(context, date, type) async {
    try {
      var HomeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmAppointmentCalendarAPI(
        HomeProv.empId,
        HomeProv.session,
        date,
        type,
      );
      _isLoading = true;
      notifyListeners();
      if (data != null) {
        if (data.error == "0") {
          _isLoading = false;
          _appointmentsList = data.appointments!;
          notifyListeners();
        } else {
          toast(context, data.message);
          _isLoading = false;
          notifyListeners();
        }
      } else {
        _isLoading = false;
        notifyListeners();
      }
    } catch (e) {
      _isLoading = false;
      notifyListeners();
    }
  }
}
