import 'package:flutter/material.dart';
import 'package:generp/Models/PaymentCollectionResponse.dart';
import 'package:generp/Notifiers/HomeScreenNotifier.dart';
import 'package:generp/services/api_calling.dart';
import 'package:provider/provider.dart';

import '../Models/AccountSuggestionResponse.dart';

class Paymentcollectionprovider extends ChangeNotifier {
  List<PC_List> _paymentCollectionList = [];
  List<AccountList> _accountList = [];
  bool _isLoading = false;

  List<PC_List> get paymenCollectionList => _paymentCollectionList;
  List<AccountList> get accountList => _accountList;
  bool get isLoading => _isLoading;

  void resetAll() {
    _accountList = [];
    _paymentCollectionList = [];
  }

  Future<void> PaymentCollectionAPI(BuildContext context) async {
    try {
      var HomeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );
      final data = await ApiCalling.paymentCollectionListAPI(
        HomeProvider.empId,
        HomeProvider.session,
      );

      if (data != null) {
        if (data.sessionExists == 1) {
          if (data.error == 0) {
            _paymentCollectionList = data.list!;
            _isLoading = false;
          } else {
            _isLoading = false;
          }
          notifyListeners();
        } else {
          // SharedpreferencesService().clearPreferences();
          // Navigator.push(
          //   context,
          //   MaterialPageRoute(builder: (context) => Splash()),
          // );
        }
        notifyListeners();
      }
    } on Error catch (e) {
      print(e.toString());
    }
  }

  Future<void> AccountSuggestionAPI(BuildContext context, searchText) async {
    try {
      var HomeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );
      final data = await ApiCalling.AccountSuggestionAPI(
        HomeProvider.empId,
        HomeProvider.session,
        searchText,
      );

      if (data != null) {
        if (data.sessionExists == 1) {
          if (data.error == 0) {
            _isLoading = false;
            _accountList = data.accountList!;
            _isLoading = false;
            notifyListeners();
          } else {
            _isLoading = false;
            _accountList = [];
            notifyListeners();
          }
        } else {
          // SharedpreferencesService().clearPreferences();
          // Navigator.push(
          //   context,
          //   MaterialPageRoute(builder: (context) => LoginScreen()),
          // );
        }
      } else {
        _isLoading = false;
      }
    } on Error catch (e) {
      print(e.toString());
    }
  }
}
