class PaymentCollectionResponse {
  List<PC_List>? list;
  int? error;
  int? sessionExists;

  PaymentCollectionResponse({this.list, this.error, this.sessionExists});

  PaymentCollectionResponse.fromJson(Map<String, dynamic> json) {
    if (json['list'] != null) {
      list = <PC_List>[];
      json['list'].forEach((v) {
        list!.add(PC_List.fromJson(v));
      });
    }
    error = json['error'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (list != null) {
      data['list'] = list!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class PC_List {
  String? accountName;
  String? amount;
  String? paymentMode;
  String? paymentRefNo;
  String? paymentProofFilePath;
  String? paymentProofViewFileName;
  String? approvalStatus;

  PC_List({
    this.accountName,
    this.amount,
    this.paymentMode,
    this.paymentRefNo,
    this.paymentProofFilePath,
    this.paymentProofViewFileName,
    this.approvalStatus,
  });

  PC_List.fromJson(Map<String, dynamic> json) {
    accountName = json['account_name'];
    amount = json['amount'];
    paymentMode = json['payment_mode'];
    paymentRefNo = json['payment_ref_no'];
    paymentProofFilePath = json['payment_proof_file_path'];
    paymentProofViewFileName = json['payment_proof_view_file_name'];
    approvalStatus = json['approval_status'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['account_name'] = accountName;
    data['amount'] = amount;
    data['payment_mode'] = paymentMode;
    data['payment_ref_no'] = paymentRefNo;
    data['payment_proof_file_path'] = paymentProofFilePath;
    data['payment_proof_view_file_name'] = paymentProofViewFileName;
    data['approval_status'] = approvalStatus;
    return data;
  }
}
