import 'dart:io';

import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/ordersProvider/tpcAgentsProvider.dart';
import 'package:provider/provider.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';
import '../finance/FileViewer.dart';
import 'ordersDetailsByModes.dart';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:generp/Utils/commonServices.dart';

class Tpcagentdetailsbymode extends StatefulWidget {
  final tpcAgentId;
  final pageTitleName;
  final mode;

  const Tpcagentdetailsbymode({
    super.key,
    this.tpcAgentId,
    this.pageTitleName,
    this.mode,
  });

  @override
  State<Tpcagentdetailsbymode> createState() => _TpcagentdetailsbymodeState();
}

class _TpcagentdetailsbymodeState extends State<Tpcagentdetailsbymode> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var provider = Provider.of<Tpcagentsprovider>(context, listen: false);
      provider.TPCAgentsDetailsAPIFunction(context, widget.tpcAgentId);
      provider.showMoreDetails = false;
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () async {
                Provider.of<Tpcagentsprovider>(
                  context,
                  listen: false,
                ).resetAll();

                return onBackPressed(context);
              },
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Tpcagentsprovider>(
      builder: (context, provider, child) {
        var tpcAgentDetails = provider.TPCAgentsDetails;
        var tpcReqAmt = provider.TPCRequestedAmounts;

        final headings1 = [
          "TPC Agent Bank Name",
          "Bank Beneficiary Name",
          "Bank Account No",
          "Bank IFSC Code",
          "ID Proof",
        ];
        final subHeadings1 = [
          tpcAgentDetails.bankName ?? "-",
          tpcAgentDetails.bankBeneficiaryName ?? "-",
          tpcAgentDetails.bankAccountNo ?? "-",
          tpcAgentDetails.bankIfscCode ?? "-",
          "View",
        ];
        final headings2 = ["Order Received Date", "Note"];
        final subHeadings2 = [
          tpcAgentDetails.createdDatetime ?? "-",
          tpcAgentDetails.note ?? "-",
        ];

        final sections = [
          {
            "title": "Bank Details",
            "headings": headings1,
            "subHeadings": subHeadings1,
          },
          {
            "title": "Other Details",
            "headings": headings2,
            "subHeadings": subHeadings2,
          },
        ];
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2New(
            context,
            widget.pageTitleName,
            provider.resetAll,
            SizedBox(width: 0),
            0xFFFFFFFF,
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body: SingleChildScrollView(
            child: Column(
              children: [
                Card(
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.only(
                      bottomLeft: Radius.circular(30),
                      bottomRight: Radius.circular(30),
                    ),
                  ),
                  margin: EdgeInsets.symmetric(horizontal: 0),
                  elevation: 2,

                  child: Column(
                    children: [
                      Container(
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.vertical(
                            bottom: Radius.circular(30),
                          ),
                        ),
                        // margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                        padding: EdgeInsets.symmetric(
                          vertical: 10,
                          horizontal: 10,
                        ),
                        child: Column(
                          children: [
                            Row(
                              children: [
                                Expanded(
                                  flex: 1,
                                  child: SizedBox(
                                    height: 50,
                                    width: 35,
                                    child: SvgPicture.asset(
                                      "assets/svg/crm/lead_details_ic.svg",
                                    ),
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(
                                  flex: 5,
                                  child: SizedBox(
                                    child: Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Padding(
                                          padding: const EdgeInsets.all(1),
                                          child: Text(
                                            tpcAgentDetails.name ?? "-",
                                            style: TextStyle(
                                              fontFamily: "JakartaMedium",
                                              fontSize: 14,
                                              color: AppColors.semi_black,
                                            ),
                                          ),
                                        ),
                                        InkResponse(
                                          onTap: () {
                                            launch(
                                              'tel://${tpcAgentDetails.mobileNumber}',
                                            );
                                          },
                                          child: Padding(
                                            padding: const EdgeInsets.symmetric(
                                              vertical: 3.0,
                                            ),
                                            child: Text(
                                              tpcAgentDetails.mobileNumber ??
                                                  "-",
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 14,
                                                color: AppColors.grey_semi,
                                                decoration:
                                                    TextDecoration.underline,
                                                decorationStyle:
                                                    TextDecorationStyle.dashed,
                                                decorationColor:
                                                    AppColors.grey_semi,
                                              ),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                                SizedBox(width: 10),
                              ],
                            ),
                            SizedBox(height: 5),
                            Visibility(
                              visible: provider.showMoreDetails ? true : false,
                              child: Column(
                                children: List.generate(sections.length, (
                                  sectionIndex,
                                ) {
                                  final section = sections[sectionIndex];
                                  final title = section["title"] as String;
                                  final headings =
                                      section["headings"] as List<String>;
                                  final subHeadings =
                                      section["subHeadings"] as List<String>;

                                  return Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Container(
                                        padding: EdgeInsets.symmetric(
                                          vertical: 4,
                                        ),
                                        child: Row(
                                          children: [
                                            Expanded(
                                              flex: 3,
                                              child: Text(
                                                title,
                                                style: TextStyle(
                                                  fontSize: 14,
                                                  fontFamily: "JakartaSemiBold",
                                                ),
                                              ),
                                            ),
                                            Expanded(
                                              flex: 6,
                                              child: DottedLine(
                                                dashGapLength: 4,
                                                dashGapColor: Colors.white,
                                                dashColor: AppColors.grey_semi,
                                                dashLength: 2,
                                                lineThickness: 0.5,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),

                                      Column(
                                        children: List.generate(headings.length, (
                                          j,
                                        ) {
                                          if (headings[j] == "ID Proof" &&
                                              tpcAgentDetails
                                                      .idProofDirFilePath ==
                                                  "") {
                                            return SizedBox.shrink();
                                          }
                                          return Container(
                                            padding: EdgeInsets.symmetric(
                                              vertical: 7,
                                            ),
                                            child: Row(
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              children: [
                                                Expanded(
                                                  child: Text(
                                                    headings[j],
                                                    style: TextStyle(
                                                      fontFamily:
                                                          "JakartaRegular",
                                                      fontSize: 14,
                                                      color:
                                                          AppColors.semi_black,
                                                    ),
                                                  ),
                                                ),
                                                Expanded(
                                                  child: InkResponse(
                                                    onTap:
                                                        subHeadings[j] == "View"
                                                            ? () {
                                                              Navigator.push(
                                                                context,
                                                                MaterialPageRoute(
                                                                  builder:
                                                                      (
                                                                        context,
                                                                      ) => Fileviewer(
                                                                        fileName:
                                                                            tpcAgentDetails.idProofViewFileName ??
                                                                            "",
                                                                        fileUrl:
                                                                            tpcAgentDetails.idProofDirFilePath ??
                                                                            "",
                                                                        downloadEnable: false,
                                                                      ),
                                                                ),
                                                              );
                                                            }
                                                            : null,
                                                    child: Text(
                                                      subHeadings[j].isEmpty
                                                          ? "-"
                                                          : subHeadings[j],
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        decoration:
                                                            subHeadings[j] ==
                                                                    "View"
                                                                ? TextDecoration
                                                                    .underline
                                                                : TextDecoration
                                                                    .none,
                                                        decorationStyle:
                                                            TextDecorationStyle
                                                                .dashed,
                                                        decorationColor:
                                                            subHeadings[j] ==
                                                                    "View"
                                                                ? AppColors
                                                                    .app_blue
                                                                : Color(
                                                                  0xFF818181,
                                                                ),
                                                        color:
                                                            subHeadings[j] ==
                                                                    "View"
                                                                ? AppColors
                                                                    .app_blue
                                                                : Color(
                                                                  0xFF818181,
                                                                ),
                                                      ),
                                                    ),
                                                  ),
                                                ),
                                              ],
                                            ),
                                          );
                                        }),
                                      ),
                                    ],
                                  );
                                }),
                              ),
                            ),

                            InkResponse(
                              onTap: () async {
                                provider.showMoreDetails =
                                    !provider.showMoreDetails;
                              },
                              child: Container(
                                padding: EdgeInsets.symmetric(vertical: 5),
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    Text(
                                      provider.showMoreDetails
                                          ? "Hide Details"
                                          : "View Details",
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                        fontSize: 14,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                    Transform.flip(
                                      flipY:
                                          provider.showMoreDetails
                                              ? true
                                              : false,
                                      child: SvgPicture.asset(
                                        "assets/svg/arrow_dropdown.svg",
                                        height: 25,
                                        width: 20,
                                        color: AppColors.app_blue,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),

                Container(
                  alignment: Alignment.topLeft,
                  padding: EdgeInsets.only(top: 15, left: 10),
                  child: Text(
                    "TPC Amounts Requested",
                    style: TextStyle(
                      fontSize: 14,
                      color: AppColors.grey_thick,
                      fontFamily: "JakartaMedium",
                    ),
                  ),
                ),
                ListView.builder(
                  scrollDirection: Axis.vertical,
                  shrinkWrap: true,
                  physics: NeverScrollableScrollPhysics(),
                  itemCount: tpcReqAmt.length,
                  padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),

                  itemBuilder: (context, index) {
                    return InkResponse(
                      onTap: () {
                        Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder:
                                (context) => Ordersdetailsbymodes(
                                  pageTitleName: "CRM Order Details",
                                  mode: widget.mode,
                                  orderId: tpcReqAmt[index].orderId,
                                ),
                          ),
                        );
                      },
                      child: Container(
                        width: MediaQuery.of(context).size.width * 0.9,
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(14),
                        ),
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 15,
                        ),
                        margin: EdgeInsets.symmetric(
                          horizontal: 5,
                          vertical: 5,
                        ),

                        child: Column(
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                  flex: 1,
                                  child: SvgPicture.asset(
                                    "assets/svg/order/tpc_details_req_ic.svg",
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(
                                  flex: 6,
                                  child: SizedBox(
                                    child: Column(
                                      // mainAxisAlignment: MainAxisAlignment.start,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      children: [
                                        Row(
                                          children: [
                                            Expanded(
                                              flex: 4,
                                              child: Column(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.start,
                                                children: [
                                                  InkResponse(
                                                    onTap: () {
                                                      Navigator.push(
                                                        context,
                                                        MaterialPageRoute(
                                                          builder:
                                                              (
                                                                context,
                                                              ) => Ordersdetailsbymodes(
                                                                pageTitleName:
                                                                    "CRM Order Details",
                                                                mode:
                                                                    widget.mode,
                                                                orderId:
                                                                    tpcReqAmt[index]
                                                                        .orderId,
                                                              ),
                                                        ),
                                                      );
                                                    },
                                                    child: Padding(
                                                      padding:
                                                          const EdgeInsets.symmetric(
                                                            vertical: 4.0,
                                                          ),
                                                      child: Text(
                                                        tpcReqAmt[index]
                                                                .customerName ??
                                                            "-",
                                                        style: TextStyle(
                                                          decoration:
                                                              TextDecoration
                                                                  .underline,
                                                          decorationStyle:
                                                              TextDecorationStyle
                                                                  .dashed,
                                                          decorationColor:
                                                              AppColors
                                                                  .semi_black,
                                                          height: 1.5,
                                                          fontFamily:
                                                              "JakartaRegular",
                                                          fontSize: 14,
                                                          color:
                                                              AppColors
                                                                  .semi_black,
                                                        ),
                                                      ),
                                                    ),
                                                  ),
                                                  Text(
                                                    tpcReqAmt[index]
                                                            .orderNumber ??
                                                        "-",
                                                    style: TextStyle(
                                                      fontFamily:
                                                          "JakartaRegular",
                                                      fontSize: 14,
                                                      color:
                                                          AppColors.grey_semi,
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ),
                                            Expanded(
                                              flex: 2,
                                              child: Container(
                                                decoration: BoxDecoration(
                                                  borderRadius:
                                                      BorderRadius.circular(8),
                                                  color:
                                                      AppColors
                                                          .requested_bg_color,
                                                ),
                                                padding: EdgeInsets.symmetric(
                                                  horizontal: 5,
                                                  vertical: 10,
                                                ),
                                                child: Center(
                                                  child: Text(
                                                    textAlign: TextAlign.right,
                                                    tpcReqAmt[index]
                                                            .tpcStatus ??
                                                        "-",
                                                    style: TextStyle(
                                                      fontFamily:
                                                          "JakartaMedium",
                                                      fontSize: 14,
                                                      color: AppColors.app_blue,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ],
                            ),
                            Container(
                              padding: EdgeInsets.symmetric(vertical: 7.5),
                              child: Row(
                                children: [
                                  Expanded(
                                    flex: 4,
                                    child: Text(
                                      "Order Details",
                                      style: TextStyle(
                                        fontSize: 14,
                                        fontFamily: "JakartaSemiBold",
                                      ),
                                    ),
                                  ),
                                  Expanded(
                                    flex: 6,
                                    child: DottedLine(
                                      dashGapLength: 4,
                                      dashGapColor: Colors.white,
                                      dashColor: AppColors.grey_semi,
                                      dashLength: 2,
                                      lineThickness: 0.5,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            ...List.generate(2, (j) {
                              final heads = [
                                "Order Amount",
                                "Level 2 Approved Amount",
                              ];
                              final subHeads = [
                                "${tpcReqAmt[index].totalAmount}",
                                "${tpcReqAmt[index].level2TpcApprovedAmount}",
                              ];
                              return Container(
                                padding: EdgeInsets.symmetric(vertical: 3),
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Expanded(
                                      child: Text(
                                        textAlign: TextAlign.left,
                                        heads[j],
                                        style: TextStyle(
                                          fontFamily: "JakartaRegular",
                                          fontSize: 14,
                                          color: AppColors.semi_black,
                                        ),
                                      ),
                                    ),
                                    Expanded(
                                      child: Text(
                                        textAlign: TextAlign.right,
                                        subHeads[j] == "" ? "-" : subHeads[j],
                                        style: TextStyle(
                                          fontSize: 14,
                                          color: Color(0xFF818181),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              );
                            }),
                          ],
                        ),
                      ),
                    );
                  },
                ),
              ],
            ),
          ),
        );
      },
    );
  }

  Widget _scaffold1(BuildContext context) {
    return Consumer<Tpcagentsprovider>(
      builder: (context, provider, child) {
        var tpcAgentDetails = provider.TPCAgentsDetails;
        var tpcReqAmt = provider.TPCRequestedAmounts;
        return WillPopScope(
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar2(
                context,
                widget.pageTitleName,
                provider.resetAll,
                SizedBox(width: 0),
              ),
              backgroundColor: AppColors.scaffold_bg_color,
              body: Container(
                child: SingleChildScrollView(
                  child: Column(
                    children: [
                      Container(
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        margin: EdgeInsets.symmetric(
                          vertical: 10,
                          horizontal: 10,
                        ),
                        padding: EdgeInsets.symmetric(
                          vertical: 10,
                          horizontal: 10,
                        ),
                        child: Column(
                          children: [
                            Row(
                              children: [
                                Expanded(
                                  flex: 1,
                                  child: Container(
                                    height: 50,
                                    width: 35,
                                    padding: EdgeInsets.all(8.0),
                                    decoration: BoxDecoration(
                                      color: Color(0xFFFFF3CE),
                                      borderRadius: BorderRadius.circular(8),
                                    ),
                                    child: SvgPicture.asset(
                                      "assets/svg/fin_ic.svg",
                                    ),
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(
                                  flex: 4,
                                  child: SizedBox(
                                    child: Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Text(
                                          tpcAgentDetails.name ?? "-",
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                        Text(
                                          "${tpcAgentDetails.mobileNumber}",
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                            fontSize: 14,
                                            color: AppColors.app_blue,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ],
                            ),
                            Divider(thickness: 0.5, color: Color(0xFFD7D7D7)),
                            ...List.generate(provider.subHeadings.length, (j) {
                              return Container(
                                padding: EdgeInsets.symmetric(vertical: 7),
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Expanded(
                                      child: Text(
                                        provider.Headings[j],
                                        style: TextStyle(
                                          fontFamily: "JakartaMedium",
                                          fontSize: 14,
                                          color: AppColors.semi_black,
                                        ),
                                      ),
                                    ),
                                    Expanded(
                                      child: InkResponse(
                                        onTap: () {
                                          if (provider.Headings[j] ==
                                              "ID Proof") {
                                            Navigator.push(
                                              context,
                                              MaterialPageRoute(
                                                builder:
                                                    (context) => Fileviewer(
                                                      fileName:
                                                          tpcAgentDetails
                                                              .idProofViewFileName!,
                                                      fileUrl:
                                                          tpcAgentDetails
                                                              .idProofDirFilePath!,
                                                      downloadEnable: false,
                                                    ),
                                              ),
                                            );
                                          }
                                        },
                                        child: Text(
                                          provider.subHeadings[j],
                                          style: TextStyle(
                                            fontSize: 14,
                                            color:
                                                provider.Headings[j] ==
                                                        "ID Proof"
                                                    ? AppColors.app_blue
                                                    : Color(0xFF818181),
                                            decoration:
                                                provider.Headings[j] ==
                                                        "ID Proof"
                                                    ? TextDecoration.underline
                                                    : TextDecoration.none,
                                            decorationColor:
                                                provider.Headings[j] ==
                                                        "ID Proof"
                                                    ? AppColors.app_blue
                                                    : AppColors.white,
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              );
                            }),
                          ],
                        ),
                      ),

                      Container(
                        alignment: Alignment.topLeft,
                        padding: EdgeInsets.symmetric(
                          vertical: 5,
                          horizontal: 10,
                        ),
                        child: Text(
                          "TPC Amounts Requested",
                          style: TextStyle(
                            fontSize: 14,
                            color: AppColors.grey_thick,
                          ),
                        ),
                      ),
                      ListView.builder(
                        scrollDirection: Axis.vertical,
                        shrinkWrap: true,
                        physics: NeverScrollableScrollPhysics(),
                        itemCount: tpcReqAmt.length,
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),

                        itemBuilder: (context, index) {
                          return Container(
                            margin: EdgeInsets.symmetric(vertical: 5),
                            padding: EdgeInsets.symmetric(
                              horizontal: 15,
                              vertical: 10,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(20),
                            ),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: List.generate(6, (j) {
                                final textheads = [
                                  "Customer Name",
                                  "Order Number",
                                  "Order Amount",
                                  "Level 2 Approved Amount",
                                  "Status",
                                  "Action",
                                ];
                                final textSubheads = [
                                  "${tpcReqAmt[index].customerName}",
                                  "${tpcReqAmt[index].orderNumber}",
                                  "${tpcReqAmt[index].totalAmount}",
                                  "${tpcReqAmt[index].level2TpcApprovedAmount}",
                                  "${tpcReqAmt[index].tpcStatus}",
                                  "View",
                                ];
                                return Container(
                                  padding: EdgeInsets.symmetric(
                                    vertical: 6,
                                    horizontal: 0,
                                  ),
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        child: Text(
                                          textheads[j].toString(),
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                        ),
                                      ),
                                      Expanded(
                                        child: InkResponse(
                                          onTap: () {
                                            if (textheads[j] == "Action") {
                                              Navigator.push(
                                                context,
                                                MaterialPageRoute(
                                                  builder:
                                                      (
                                                        context,
                                                      ) => Ordersdetailsbymodes(
                                                        pageTitleName:
                                                            "CRM Order Details",
                                                        mode: widget.mode,
                                                        orderId:
                                                            tpcReqAmt[index]
                                                                .orderId,
                                                      ),
                                                ),
                                              );
                                            }
                                          },
                                          child: SizedBox(
                                            // height:45,
                                            width:
                                                MediaQuery.of(
                                                  context,
                                                ).size.width *
                                                0.75,
                                            child: Text(
                                              textSubheads[j],
                                              maxLines: 2,
                                              overflow: TextOverflow.ellipsis,
                                              style: TextStyle(
                                                color:
                                                    textheads[j] == "Action"
                                                        ? AppColors.app_blue
                                                        : Color(0xFF818181),
                                                decoration:
                                                    textheads[j] == "Action"
                                                        ? TextDecoration
                                                            .underline
                                                        : TextDecoration.none,
                                                decorationColor:
                                                    textheads[j] == "Action"
                                                        ? AppColors.app_blue
                                                        : AppColors.white,
                                              ),
                                            ),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                );
                              }),
                            ),
                          );
                        },
                      ),
                    ],
                  ),
                ),
              ),
            ),
          ),

          onWillPop: () {
            return onBackPressed(context);
          },
        );
      },
    );
  }
}
