import 'package:flutter/foundation.dart';
import 'package:provider/provider.dart';

import '../../Models/hrmmodels/ogresponse.dart';
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class Orgprovider extends ChangeNotifier {
  List<Children> _employees = [];

  String? _rootName;
  String? _rootId;
  String? _rootTitle;
  String? _rootProfile;

  List<Children> get employees => _employees;

  String? get rootName => _rootName;
  String? get rootID => _rootId;
  String? get rootTitle => _rootTitle;
  String? get rootProfile => _rootProfile;

  Future<void> ogChart(context) async {
    try {
      var homeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );
      final data = await ApiCalling.ogChartAPI(
        homeProvider.empId,
        homeProvider.session,
      );
      if (data != null) {
        if (data.error == "0") {
          _rootName = data.name!;
          _rootId = data.id!;
          _rootProfile = data.profile!;
          _rootTitle = data.title!;
          _employees = data.children!;
          notifyListeners();
        }
      }
    } catch (e) {}
  }
}
