import 'package:flutter/material.dart';
import 'package:generp/Utils/SharedpreferencesService.dart';
import 'package:generp/screens/HomeScreen.dart';
import 'package:generp/services/api_calling.dart';
import 'package:generp/screens/LoginScreen.dart';

import '../Utils/commonServices.dart';

class UpdatePasswordProvider with ChangeNotifier {
  TextEditingController password = TextEditingController();
  TextEditingController confPassword = TextEditingController();
  String? passwordError;
  String? confirmPasswordError;
  bool _pwdVisible = false;
  bool _confPwdVisible = false;
  bool isLoading = false;

  bool get pwdVisible => _pwdVisible;
  bool get confPwdVisible => _confPwdVisible;

  bool pwdVisibility() {
    _pwdVisible = !_pwdVisible;
    print(_pwdVisible);
    notifyListeners();
    return _pwdVisible;
  }

  bool confPwdVisibility() {
    _confPwdVisible = !_confPwdVisible;
    print(_confPwdVisible);
    notifyListeners();
    return _confPwdVisible;
  }

  Future<void> updatePassword(BuildContext context) async {
    passwordError = null;
    confirmPasswordError = null;

    final pass = password.text.trim();
    final confPass = confPassword.text.trim();

    if (pass.isEmpty || pass.length < 8) {
      passwordError =
          pass.isEmpty
              ? "Enter Password"
              : "Password must be at least 8 characters";
    }
    if (confPass.isEmpty || confPass.length < 8) {
      confirmPasswordError =
          confPass.isEmpty
              ? "Enter Confirm Password"
              : "Confirm Password must be at least 8 characters";
    }
    if (pass != confPass) {
      confirmPasswordError = "Passwords do not match";
    }

    if (passwordError != null || confirmPasswordError != null) {
      notifyListeners();
      return;
    }

    isLoading = true;
    notifyListeners();

    try {
      var session = await SharedpreferencesService().getString("Session_id");
      var empId = await SharedpreferencesService().getString("UserId");
      print("Okay ${password.text}");
      print("Okay ${confPassword.text}");
      final data = await ApiCalling.UpdatePasswordApi(
        empId,
        session,
        pass,
        confPass,
      );
      var loginStatus = await SharedpreferencesService().getInt("loginStatus");
      if (data != null) {
        if (loginStatus == 1) {
          if (data.error == 0) {
            toast(context, data.message);
            Navigator.push(
              context,
              MaterialPageRoute(
                builder: (context) => MyHomePage(),
                settings: RouteSettings(name: "MyHomePage"),
              ),
            );
          } else {
            toast(context, data.message);
          }
        } else {
          print("else case");
          SharedpreferencesService().clearPreferences();
          Navigator.push(
            context,
            MaterialPageRoute(
              builder: (context) => LoginScreen(),
              settings: RouteSettings(name: "LoginScreen"),
            ),
          );
        }
      }
    } catch (e) {
      toast(context, "Something went wrong");
    } finally {
      isLoading = false;
      notifyListeners();
    }
  }

  void onChangePassword(String value) {
    passwordError = null;
    notifyListeners();
  }

  void onChangeConfPassword(String value) {
    confirmPasswordError = null;
    notifyListeners();
  }
}
