import 'package:flutter/cupertino.dart';
import 'package:generp/services/api_calling.dart';
import 'package:provider/provider.dart';

import '../Models/PaymentCollectionWalletResponse.dart';
import 'HomeScreenNotifier.dart';

class Pcwalletprovider extends ChangeNotifier {
  List<HistoryList> _historyList = [];
  TotalDet _totalDet = TotalDet();
  bool _isLoading = false;

  bool get isLoading => _isLoading;
  TotalDet get totlDetails => _totalDet;
  List<HistoryList> get historyList => _historyList;

  Future<void> LoadTransactionsListAPI(BuildContext context) async {
    try {
      var HomeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );
      final data = await ApiCalling.loadTransactionsListAPI(
        HomeProvider.empId,
        HomeProvider.session,
      );

      if (data != null) {
        if (data.error == 0) {
          _historyList = data.historyList!;
          _totalDet = data.totalDet!;
          _isLoading = false;
        } else {
          _isLoading = false;
        }
        notifyListeners();
      } else {
        print("Something went wrong, Please try again.");
      }
    } on Exception catch (e) {
      print("$e");
    }
  }

  Map<String, List<HistoryList>> groupByDate(List<HistoryList> list) {
    Map<String, List<HistoryList>> grouped = {};

    for (var item in list) {
      String date = item.datetime!;
      if (!grouped.containsKey(date)) {
        grouped[date] = [];
      }
      grouped[date]!.add(item);
    }

    return grouped;
  }
}
