class ogresponse {
  String? id;
  String? name;
  String? title;
  String? profile;
  List<Children>? children;
  String? error;
  String? message;
  int? sessionExists;

  ogresponse({
    this.id,
    this.name,
    this.title,
    this.profile,
    this.children,
    this.error,
    this.message,
    this.sessionExists,
  });

  ogresponse.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    title = json['title'];
    profile = json['profile'];
    if (json['children'] != null) {
      children = <Children>[];
      json['children'].forEach((v) {
        children!.add(Children.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['title'] = title;
    data['profile'] = profile;
    if (children != null) {
      data['children'] = children!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class Children {
  String? id;
  String? name;
  String? title;
  String? profile;
  List<Children>? children;

  Children({this.id, this.name, this.title, this.profile, this.children});

  Children.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    title = json['title'];
    profile = json['profile'];
    if (json['children'] != null) {
      children = <Children>[];
      json['children'].forEach((v) {
        children!.add(Children.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['title'] = title;
    data['profile'] = profile;
    if (children != null) {
      data['children'] = children!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}
