class jobDescriptionResponse {
  JobDescription? jobDescription;
  String? error;
  String? message;
  int? sessionExists;

  jobDescriptionResponse({
    this.jobDescription,
    this.error,
    this.message,
    this.sessionExists,
  });

  jobDescriptionResponse.fromJson(Map<String, dynamic> json) {
    jobDescription =
        json['job_description'] != null
            ? JobDescription.fromJson(json['job_description'])
            : null;
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (jobDescription != null) {
      data['job_description'] = jobDescription!.toJson();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class JobDescription {
  String? name;
  String? jobDescription;
  String? id;

  JobDescription({this.name, this.jobDescription, this.id});

  JobDescription.fromJson(Map<String, dynamic> json) {
    name = json['name'];
    jobDescription = json['job_description'];
    id = json['id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['name'] = name;
    data['job_description'] = jobDescription;
    data['id'] = id;
    return data;
  }
}
