class ContactListResponse {
  String? error;
  List<EmpContactList>? empContactList;
  String? message;
  int? sessionExists;

  ContactListResponse(
      {this.error, this.empContactList, this.message, this.sessionExists});

  ContactListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['emp_contact_list'] != null) {
      empContactList = <EmpContactList>[];
      json['emp_contact_list'].forEach((v) {
        empContactList!.add(new EmpContactList.fromJson(v));
      });
    }
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.empContactList != null) {
      data['emp_contact_list'] =
          this.empContactList!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class EmpContactList {
  String? name;
  String? mobileNumber;
  String? designation;
  String? branchName;
  String? profileImage;

  EmpContactList(
      {this.name, this.mobileNumber, this.designation, this.branchName});

  EmpContactList.fromJson(Map<String, dynamic> json) {
    name = json['name'];
    mobileNumber = json['mobile_number'];
    designation = json['designation'];
    branchName = json['branch_name'];
    profileImage = json['profile_image'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['name'] = this.name;
    data['mobile_number'] = this.mobileNumber;
    data['designation'] = this.designation;
    data['branch_name'] = this.branchName;
    data['profile_image'] = this.profileImage;
    return data;
  }
}
