class ordersDetailsDispatchOrderViewResponse {
  List<Products>? products;
  String? error;
  String? message;

  ordersDetailsDispatchOrderViewResponse({
    this.products,
    this.error,
    this.message,
  });

  ordersDetailsDispatchOrderViewResponse.fromJson(Map<String, dynamic> json) {
    if (json['products'] != null) {
      products = <Products>[];
      json['products'].forEach((v) {
        products!.add(Products.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (products != null) {
      data['products'] = products!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class Products {
  String? id;
  String? orderId;
  String? productId;
  String? pdiId;
  String? qty;
  String? unitPrice;
  String? cgstPercentage;
  String? sgstPercentage;
  String? igstPercentage;
  String? totalPrice;
  String? isExist;
  String? createdDatetime;
  String? updatedDatetime;
  String? productName;
  String? crmOrderPId;

  Products({
    this.id,
    this.orderId,
    this.productId,
    this.pdiId,
    this.qty,
    this.unitPrice,
    this.cgstPercentage,
    this.sgstPercentage,
    this.igstPercentage,
    this.totalPrice,
    this.isExist,
    this.createdDatetime,
    this.updatedDatetime,
    this.productName,
    this.crmOrderPId,
  });

  Products.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    orderId = json['order_id'];
    productId = json['product_id'];
    pdiId = json['pdi_id'];
    qty = json['qty'];
    unitPrice = json['unit_price'];
    cgstPercentage = json['cgst_percentage'];
    sgstPercentage = json['sgst_percentage'];
    igstPercentage = json['igst_percentage'];
    totalPrice = json['total_price'];
    isExist = json['is_exist'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    productName = json['product_name'];
    crmOrderPId = json['crm_order_p_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['order_id'] = orderId;
    data['product_id'] = productId;
    data['pdi_id'] = pdiId;
    data['qty'] = qty;
    data['unit_price'] = unitPrice;
    data['cgst_percentage'] = cgstPercentage;
    data['sgst_percentage'] = sgstPercentage;
    data['igst_percentage'] = igstPercentage;
    data['total_price'] = totalPrice;
    data['is_exist'] = isExist;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['product_name'] = productName;
    data['crm_order_p_id'] = crmOrderPId;
    return data;
  }
}
