class addOrderAccontDetailsResponse {
  AccountDetails? accountDetails;
  String? error;
  String? message;

  addOrderAccontDetailsResponse({
    this.accountDetails,
    this.error,
    this.message,
  });

  addOrderAccontDetailsResponse.fromJson(Map<String, dynamic> json) {
    accountDetails =
        json['account_details'] != null
            ? AccountDetails.fromJson(json['account_details'])
            : null;
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (accountDetails != null) {
      data['account_details'] = accountDetails!.toJson();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class AccountDetails {
  String? id;
  String? tempId;
  String? ownerId;
  String? accManagerId;
  String? name;
  String? salutationName;
  String? subLocality;
  String? district;
  String? state;
  String? pincode;
  String? address;
  String? date;
  String? source;
  String? reference;
  String? segment;
  String? team;
  String? gstNumber;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  AccountDetails({
    this.id,
    this.tempId,
    this.ownerId,
    this.accManagerId,
    this.name,
    this.salutationName,
    this.subLocality,
    this.district,
    this.state,
    this.pincode,
    this.address,
    this.date,
    this.source,
    this.reference,
    this.segment,
    this.team,
    this.gstNumber,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  AccountDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    tempId = json['temp_id'];
    ownerId = json['owner_id'];
    accManagerId = json['acc_manager_id'];
    name = json['name'];
    salutationName = json['salutation_name'];
    subLocality = json['sub_locality'];
    district = json['district'];
    state = json['state'];
    pincode = json['pincode'];
    address = json['address'];
    date = json['date'];
    source = json['source'];
    reference = json['reference'];
    segment = json['segment'];
    team = json['team'];
    gstNumber = json['gst_number'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['temp_id'] = tempId;
    data['owner_id'] = ownerId;
    data['acc_manager_id'] = accManagerId;
    data['name'] = name;
    data['salutation_name'] = salutationName;
    data['sub_locality'] = subLocality;
    data['district'] = district;
    data['state'] = state;
    data['pincode'] = pincode;
    data['address'] = address;
    data['date'] = date;
    data['source'] = source;
    data['reference'] = reference;
    data['segment'] = segment;
    data['team'] = team;
    data['gst_number'] = gstNumber;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}
