class AddOrderPaymentSelectOrderResponse {
  String? error;
  List<OrderList>? orderList;
  String? message;

  AddOrderPaymentSelectOrderResponse({
    this.error,
    this.orderList,
    this.message,
  });

  AddOrderPaymentSelectOrderResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['order_list'] != null) {
      orderList = <OrderList>[];
      json['order_list'].forEach((v) {
        orderList!.add(OrderList.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (orderList != null) {
      data['order_list'] = orderList!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    return data;
  }
}

class OrderList {
  String? orderId;
  String? orderNumber;
  String? totalAmount;
  String? balanceAmount;
  String? createdDatetime;

  OrderList({
    this.orderId,
    this.orderNumber,
    this.totalAmount,
    this.balanceAmount,
    this.createdDatetime,
  });

  OrderList.fromJson(Map<String, dynamic> json) {
    orderId = json['order_id'];
    orderNumber = json['order_number'];
    totalAmount = json['total_amount'];
    balanceAmount = json['balance_amount'];
    createdDatetime = json['created_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['order_id'] = orderId;
    data['order_number'] = orderNumber;
    data['total_amount'] = totalAmount;
    data['balance_amount'] = balanceAmount;
    data['created_datetime'] = createdDatetime;
    return data;
  }
}
