class addDirectPaymentResponse {
  List<DirectAccounts>? accounts;
  List<DirectPaymentAccounts>? paymentAccounts;
  List<DirectPaymentModes>? paymentModes;
  String? error;
  String? message;

  addDirectPaymentResponse({
    this.accounts,
    this.paymentAccounts,
    this.paymentModes,
    this.error,
    this.message,
  });

  addDirectPaymentResponse.fromJson(Map<String, dynamic> json) {
    if (json['accounts'] != null) {
      accounts = <DirectAccounts>[];
      json['accounts'].forEach((v) {
        accounts!.add(DirectAccounts.fromJson(v));
      });
    }
    if (json['payment_accounts'] != null) {
      paymentAccounts = <DirectPaymentAccounts>[];
      json['payment_accounts'].forEach((v) {
        paymentAccounts!.add(DirectPaymentAccounts.fromJson(v));
      });
    }
    if (json['payment_modes'] != null) {
      paymentModes = <DirectPaymentModes>[];
      json['payment_modes'].forEach((v) {
        paymentModes!.add(DirectPaymentModes.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (accounts != null) {
      data['accounts'] = accounts!.map((v) => v.toJson()).toList();
    }
    if (paymentAccounts != null) {
      data['payment_accounts'] =
          paymentAccounts!.map((v) => v.toJson()).toList();
    }
    if (paymentModes != null) {
      data['payment_modes'] = paymentModes!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class DirectAccounts {
  String? id;
  String? name;

  DirectAccounts({this.id, this.name});

  DirectAccounts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class DirectPaymentAccounts {
  String? id;
  String? name;

  DirectPaymentAccounts({this.id, this.name});

  DirectPaymentAccounts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class DirectPaymentModes {
  String? id;
  String? name;

  DirectPaymentModes({this.id, this.name});

  DirectPaymentModes.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}
