class StatusResponse {
  int? error;
  String? ccsUsername;
  String? ccsPassword;
  String? ccsPbxDomain;
  String? ccsPbxSipProtocol;
  String? sessionId;
  String? userId;
  String? name;
  String? emailId;
  List<String>? permissions;
  int? attStatus;
  String? appRequestAutostart;
  String? notificationsCount;
  int? sessionExists;

  StatusResponse({
    this.error,
    this.ccsUsername,
    this.ccsPassword,
    this.ccsPbxDomain,
    this.ccsPbxSipProtocol,
    this.sessionId,
    this.userId,
    this.name,
    this.emailId,
    this.permissions,
    this.attStatus,
    this.appRequestAutostart,
    this.notificationsCount,
    this.sessionExists,
  });

  StatusResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    ccsUsername = json['ccs_username'];
    ccsPassword = json['ccs_password'];
    ccsPbxDomain = json['ccs_pbx_domain'];
    ccsPbxSipProtocol = json['ccs_pbx_sip_protocol'];
    sessionId = json['session_id'];
    userId = json['user_id'];
    name = json['name'];
    emailId = json['email_id'];
    if (json['permissions'] != null) {
      permissions = json['permissions'].cast<String>();
    }
    attStatus = json['att_status'];
    appRequestAutostart = json['app_request_autostart'];
    notificationsCount = json['notifications_count'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    data['ccs_username'] = ccsUsername;
    data['ccs_password'] = ccsPassword;
    data['ccs_pbx_domain'] = ccsPbxDomain;
    data['ccs_pbx_sip_protocol'] = ccsPbxSipProtocol;
    data['session_id'] = sessionId;
    data['user_id'] = userId;
    data['name'] = name;
    data['email_id'] = emailId;
    data['permissions'] = permissions;
    data['att_status'] = attStatus;
    data['app_request_autostart'] = appRequestAutostart;
    data['notifications_count'] = notificationsCount;
    data['session_exists'] = sessionExists;
    return data;
  }
}
