class AttendanceDashboard {
  int? attStatus;
  List<AttHistory>? attHistory;
  int? sessionExists;

  AttendanceDashboard({this.attStatus, this.attHistory, this.sessionExists});

  AttendanceDashboard.fromJson(Map<String, dynamic> json) {
    attStatus = json['att_status'];
    if (json['att_history'] != null) {
      attHistory = <AttHistory>[];
      json['att_history'].forEach((v) {
        attHistory!.add(AttHistory.fromJson(v));
      });
    }
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['att_status'] = attStatus;
    if (attHistory != null) {
      data['att_history'] = attHistory!.map((v) => v.toJson()).toList();
    }
    data['session_exists'] = sessionExists;
    return data;
  }
}

class AttHistory {
  String? date;
  String? checkInTime;
  String? checkOutTime;

  AttHistory({this.date, this.checkInTime, this.checkOutTime});

  AttHistory.fromJson(Map<String, dynamic> json) {
    date = json['date'];
    checkInTime = json['check_in_time'];
    checkOutTime = json['check_out_time'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['date'] = date;
    data['check_in_time'] = checkInTime;
    data['check_out_time'] = checkOutTime;
    return data;
  }
}
